/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.event.notify.publisher;

import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.event.notify.listener.Subscriber;
import com.ovopark.dc.alarm.event.notify.publisher.EventPublisher;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkerBasedEventPublisher
extends Thread
implements EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerBasedEventPublisher.class);
    private final HashSet<Subscriber> subscribers = new HashSet();
    private final BlockingQueue<Event> queue = new ArrayBlockingQueue<Event>(1024);
    private volatile boolean shutdown = false;

    public WorkerBasedEventPublisher() {
        this.start();
    }

    @Override
    public long currentEventSize() {
        return this.queue.size();
    }

    public HashSet<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public void removeSubscriber(Subscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    public boolean publish(Event event) {
        boolean success = this.queue.offer(event);
        if (!success) {
            System.out.println("\u6dfb\u52a0\u53d1\u5e03\u65f6\u95f4\u5931\u8d25");
            LOGGER.warn("[WorkerBasedEventPublisher # publish] Error to publish event : [{}]", (Object)event.toString());
        }
        return true;
    }

    @Override
    public void notifySubscriber(Subscriber subscriber, Event event) {
        LOGGER.debug("[ UnifiedNotifyCenter ] the {} will received by {}", (Object)event, (Object)subscriber);
        Runnable job = () -> subscriber.onEvent(event);
        Executor executor = subscriber.executor();
        if (executor != null) {
            executor.execute(job);
        } else {
            try {
                job.run();
            }
            catch (Exception e) {
                LOGGER.error("Event callback exception: ", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        this.openEventHandler();
    }

    void openEventHandler() {
        try {
            for (int waitTimes = 60; !this.shutdown && !this.hasSubscriber() && waitTimes > 0; --waitTimes) {
                TimeUnit.SECONDS.sleep(1L);
            }
            while (!this.shutdown) {
                Event event = this.queue.take();
                this.receiveEvent(event);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Event listener exception : ", ex);
        }
    }

    void receiveEvent(Event event) {
        if (!this.hasSubscriber()) {
            LOGGER.warn("[NotifyCenter] the {} is lost, because there is no subscriber.", (Object)event.toString());
            return;
        }
        for (Subscriber subscriber : this.subscribers) {
            this.notifySubscriber(subscriber, event);
        }
    }

    private boolean hasSubscriber() {
        return CollectionUtils.isNotEmpty(this.subscribers);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.queue.clear();
    }
}

