/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckNotify;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckStrategy;
import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.healthcheck.pojo.Cluster;
import java.util.List;

public class HealthCheckAlarmEvent
extends Event {
    private Cluster cluster;
    private Long alarmTime = System.currentTimeMillis();
    private HealthCheckWayEnum healthCheckWayEnum;
    private AlarmHealthCheckStrategy strategy;
    private String response;
    private String responseCode;
    private String additionalMsg;
    private List<AlarmHealthCheckNotify> notifies;
    private String uniqueNo;

    public HealthCheckAlarmEvent(Cluster cluster, HealthCheckWayEnum healthCheckWayEnum, List<AlarmHealthCheckNotify> notifies) {
        this.cluster = cluster;
        this.healthCheckWayEnum = healthCheckWayEnum;
        this.notifies = notifies;
        this.uniqueNo = cluster.getStrategyUniqueNo();
    }

    public HealthCheckAlarmEvent(AlarmHealthCheckStrategy strategy, HealthCheckWayEnum healthCheckWayEnum, String response, String responseCode, String additionalMsg, List<AlarmHealthCheckNotify> notifies) {
        this.strategy = strategy;
        this.healthCheckWayEnum = healthCheckWayEnum;
        this.response = response;
        this.responseCode = responseCode;
        this.additionalMsg = additionalMsg;
        this.notifies = notifies;
        this.uniqueNo = strategy.getUniqueNo();
    }

    public Long getAlarmTime() {
        return this.alarmTime;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public HealthCheckWayEnum getHealthCheckWayEnum() {
        return this.healthCheckWayEnum;
    }

    public AlarmHealthCheckStrategy getStrategy() {
        return this.strategy;
    }

    public String getResponse() {
        return this.response;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getAdditionalMsg() {
        return this.additionalMsg;
    }

    public List<AlarmHealthCheckNotify> getNotifies() {
        return this.notifies;
    }

    public String getUniqueNo() {
        return this.uniqueNo;
    }

    public String toString() {
        return "HealthCheckAlarmEvent{cluster=" + this.cluster + "}";
    }
}

