/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.api.enums.HealthCheckObjectEnum;
import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.api.model.AlarmHealthCheckStrategyWrapper;
import com.ovopark.dc.alarm.api.util.ApplicationUtils;
import com.ovopark.dc.alarm.event.notify.UnifiedNotifyCenter;
import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.event.notify.publisher.WorkerBasedEventPublisher;
import com.ovopark.dc.alarm.healthcheck.CheckFailedEvent;
import com.ovopark.dc.alarm.healthcheck.HealthCheckResultEvent;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTaskDictionary;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTaskInitializer;
import com.ovopark.dc.alarm.healthcheck.InstanceStatus;
import com.ovopark.dc.alarm.healthcheck.pojo.Cluster;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import com.ovopark.dc.alarm.healthcheck.tcp.TcpDetectionHealthCheckProcessor;
import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.Query;
import com.ovopark.dc.alarm.http.RestResult;
import com.ovopark.dc.alarm.http.request.SyncHttpClientRequest;
import com.ovopark.dc.alarm.http.request.okhttp.OkHttpSyncClientRequest;
import com.ovopark.dc.alarm.http.template.SyncRestTemplate;
import com.ovopark.dc.alarm.http.utils.HttpUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckCommon
extends WorkerBasedEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckCommon.class);

    public static HealthCheckCommon getInstance() {
        return (HealthCheckCommon)((Object)ApplicationUtils.getBean(HealthCheckCommon.class));
    }

    public void clearTaskInstanceStatus(AlarmHealthCheckStrategyWrapper wrapper) {
        if (Objects.nonNull(wrapper)) {
            wrapper.getInstances().forEach(ai -> {
                Instance instance = Instance.toInstance(ai, HealthCheckObjectEnum.STANDALONE.getCode().equals(wrapper.getCheckObject()), wrapper.getStrategyName(), wrapper.getStrategyName());
                InstanceStatus.remove(instance);
            });
        }
    }

    public void cancelHealthCheckTask(String uniqueNo) {
        HealthCheckTask healthCheckTask = HealthCheckTaskDictionary.getTask(uniqueNo);
        if (Objects.nonNull(healthCheckTask)) {
            healthCheckTask.cancel(true);
        }
    }

    public void initOneHealthCheckTask(AlarmHealthCheckStrategyWrapper wrapper) {
        HealthCheckTaskInitializer.healthCheckInit(wrapper);
    }

    public String testConnect(Integer checkWay, String ip, Integer port, String path) {
        if (HealthCheckWayEnum.TCP_SUPER_SENSE.getCode().equals(checkWay)) {
            return this.testTcp(ip, port);
        }
        return this.testHttp(ip, port, path);
    }

    public void checkOK(Instance instance, HealthCheckTask task, String message) {
        Cluster cluster = task.getCluster();
        try {
            if (!instance.isHealthy()) {
                instance.setHealthy(true);
            }
            instance.addCheckOkCount();
            instance.setBeingChecked(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        cluster.checkHealth(instance);
        this.persistHealthCheckResult(instance, cluster, message);
    }

    public void checkFail(Instance instance, HealthCheckTask task, String message) {
        Cluster cluster = task.getCluster();
        try {
            if (instance.isHealthy()) {
                instance.setHealthy(false);
            }
            instance.addMetadata("result", message);
            instance.addCheckFailCount();
            instance.setBeingChecked(false);
            UnifiedNotifyCenter unifiedNotifyCenter = (UnifiedNotifyCenter)ApplicationUtils.getBeanProvider(UnifiedNotifyCenter.class).getIfAvailable();
            unifiedNotifyCenter.publishEvent((Event)new CheckFailedEvent(task.getCluster().getStrategyUniqueNo()));
        }
        catch (Throwable ignored) {
            log.error("\u3010HealthCheckCommon#checkFail\u3011TCP \u68c0\u6d4b\u7ed3\u679c\u53d1\u5e03\u5f02\u5e38\uff1a" + ignored);
        }
        if (!message.contains("timeout")) {
            cluster.checkHealth(instance);
        }
        this.persistHealthCheckResult(instance, cluster, message);
    }

    public Class<? extends Event> getEventType() {
        return HealthCheckResultEvent.class;
    }

    private void persistHealthCheckResult(Instance instance, Cluster cluster, String message) {
        HealthCheckResultEvent healthCheckResultEvent = HealthCheckResultEvent.createEventBuilder().setHealth(instance.isHealthy()).setHealthCheckStrategyUniqueNo(cluster.getStrategyUniqueNo()).setIp(instance.getIp()).setPort(instance.getPort()).setPath(instance.getCheckPath()).setResult(message).setStrategyName(cluster.getClusterName()).setClusterName(cluster.getClusterName()).setServiceName(cluster.getServiceName()).setCreateTime(new Date()).setLastUnhealthTime(cluster.getRecentlyUnhealthTimeMs() == null ? null : new Date(cluster.getRecentlyUnhealthTimeMs())).setCluster(cluster).build();
        UnifiedNotifyCenter unifiedNotifyCenter = (UnifiedNotifyCenter)ApplicationUtils.getBeanProvider(UnifiedNotifyCenter.class).getIfAvailable();
        unifiedNotifyCenter.publishEvent((Event)healthCheckResultEvent);
    }

    private String testTcp(String ip, Integer port) {
        SelectionKey key;
        Selector selector = TcpDetectionHealthCheckProcessor.getInstance().applySelector();
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().setSoLinger(false, -1);
            channel.socket().setReuseAddress(true);
            channel.socket().setKeepAlive(true);
            channel.socket().setTcpNoDelay(true);
            channel.connect(new InetSocketAddress(ip, (int)port));
            key = channel.register(selector, 9);
        }
        catch (Exception e) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "tcp:error:" + e.getMessage();
        }
        try {
            TimeUnit.MILLISECONDS.sleep(800L);
        }
        catch (InterruptedException e) {
            if (channel != null) {
                try {
                    channel.close();
                    key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "process:failed:" + e.getMessage();
        }
        try {
            channel.finishConnect();
        }
        catch (IOException e) {
            if (channel != null) {
                try {
                    channel.close();
                    key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "tcp:error:" + e.getMessage();
        }
        if (channel != null) {
            try {
                channel.close();
                key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "tcp:ok+";
    }

    private String testHttp(String ip, Integer port, String path) {
        SyncRestTemplate syncRestTemplate = new SyncRestTemplate((SyncHttpClientRequest)OkHttpSyncClientRequest.getInstance());
        URL host = null;
        URL target = null;
        try {
            host = new URL("http://" + ip + ":" + port);
            target = new URL(host, path);
        }
        catch (MalformedURLException e) {
            return "process:failed:" + e.getMessage();
        }
        try {
            RestResult result = syncRestTemplate.get(target.toString(), Header.EMPTY, Query.EMPTY, String.class);
            int httpCode = result.getCode();
            if (200 != httpCode) {
                return "http:" + httpCode + ":" + result.getMessage();
            }
            return "http:" + httpCode;
        }
        catch (Throwable throwable) {
            Throwable cause = throwable;
            int maxStackDepth = 50;
            for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                if (!HttpUtils.isTimeoutException((Throwable)throwable)) continue;
                return "http:timeout:" + cause.getMessage();
            }
            if (throwable instanceof ConnectException) {
                return "http:unable2connect:" + throwable.getMessage();
            }
            return "http:error:" + throwable.getMessage();
        }
    }
}

