/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckResult;
import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.healthcheck.pojo.Cluster;
import java.util.Date;

public class HealthCheckResultEvent
extends Event {
    private AlarmHealthCheckResult healthCheckResult;
    private Date lastUnhealthTime;
    private Cluster cluster;

    public static ResultEventBuilder createEventBuilder() {
        return new ResultEventBuilder();
    }

    public AlarmHealthCheckResult getHealthCheckResult() {
        return this.healthCheckResult;
    }

    public Date getLastUnhealthTime() {
        return this.lastUnhealthTime;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String toString() {
        return "HealthCheckResultEvent{healthCheckResult=" + this.healthCheckResult.toString() + "}";
    }

    public static class ResultEventBuilder {
        private Cluster cluster;
        private Integer id;
        private String healthCheckStrategyUniqueNo;
        private String ip;
        private Integer port;
        private String path;
        private Boolean health;
        private String result;
        private String strategyName;
        private String clusterName;
        private String serviceName;
        private Date createTime;
        private Date lastUnhealthTime;

        public ResultEventBuilder setId(Integer id) {
            this.id = id;
            return this;
        }

        public ResultEventBuilder setHealthCheckStrategyUniqueNo(String healthCheckStrategyUniqueNo) {
            this.healthCheckStrategyUniqueNo = healthCheckStrategyUniqueNo;
            return this;
        }

        public ResultEventBuilder setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public ResultEventBuilder setLastUnhealthTime(Date time) {
            this.lastUnhealthTime = time;
            return this;
        }

        public ResultEventBuilder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public ResultEventBuilder setPath(String path) {
            this.path = path;
            return this;
        }

        public ResultEventBuilder setHealth(Boolean health) {
            this.health = health;
            return this;
        }

        public ResultEventBuilder setResult(String result) {
            this.result = result;
            return this;
        }

        public ResultEventBuilder setStrategyName(String strategyName) {
            this.strategyName = strategyName;
            return this;
        }

        public ResultEventBuilder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public ResultEventBuilder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ResultEventBuilder setCreateTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ResultEventBuilder setCluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public HealthCheckResultEvent build() {
            HealthCheckResultEvent healthCheckResultEvent = new HealthCheckResultEvent();
            AlarmHealthCheckResult alarmHealthCheckResult = new AlarmHealthCheckResult();
            alarmHealthCheckResult.setHealth(this.health);
            alarmHealthCheckResult.setHealthCheckStrategyUniqueNo(this.healthCheckStrategyUniqueNo);
            alarmHealthCheckResult.setId(this.id);
            alarmHealthCheckResult.setResult(this.result);
            alarmHealthCheckResult.setClusterName(this.clusterName);
            alarmHealthCheckResult.setServiceName(this.serviceName);
            alarmHealthCheckResult.setPath(this.path);
            alarmHealthCheckResult.setIp(this.ip);
            alarmHealthCheckResult.setPort(this.port);
            alarmHealthCheckResult.setCreateTime(this.createTime);
            alarmHealthCheckResult.setStrategyName(this.strategyName);
            healthCheckResultEvent.lastUnhealthTime = this.lastUnhealthTime;
            healthCheckResultEvent.healthCheckResult = alarmHealthCheckResult;
            healthCheckResultEvent.cluster = this.cluster;
            return healthCheckResultEvent;
        }
    }
}

