/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckResult;
import com.ovopark.dc.alarm.event.notify.UnifiedNotifyCenter;
import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.event.notify.listener.Subscriber;
import com.ovopark.dc.alarm.healthcheck.HealthCheckResultEvent;
import com.ovopark.dc.alarm.repository.PersistService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckResultEventSubscriber
extends Subscriber<HealthCheckResultEvent> {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckResultEventSubscriber.class);
    private final UnifiedNotifyCenter unifiedNotifyCenter;
    private final PersistService persistService;

    public HealthCheckResultEventSubscriber(UnifiedNotifyCenter unifiedNotifyCenter, PersistService persistService) {
        this.unifiedNotifyCenter = unifiedNotifyCenter;
        this.persistService = persistService;
        unifiedNotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void onEvent(HealthCheckResultEvent event) {
        AlarmHealthCheckResult result = event.getHealthCheckResult();
        if (!result.getHealth().booleanValue()) {
            if (!result.getResult().contains("timeout")) {
                log.warn("[HealthCheckResult] #WARNING# {} \u5b9e\u4f8b - {} \u5065\u5eb7\u68c0\u67e5\u3010 \u5931\u8d25 \u3011[\u63cf\u8ff0:Result-{}]\uff01\u6240\u5c5e\u7b56\u7565\u540d\u79f0-{} {} ", new Object[]{DateFormatUtils.format((Date)result.getCreateTime(), (String)"yyyy-dd-MM HH:mm:ss"), result.getIp() + ":" + result.getPort(), result.getResult(), result.getClusterName(), result.getIp() + ":" + result.getPort() + (String)(StringUtils.isBlank((CharSequence)result.getPath()) ? "" : "/" + result.getPath())});
            }
            this.persistService.getHealthCheckResult().save((Object)event.getHealthCheckResult());
        }
        this.persistService.getHealthCheckStrategy().updateStrateyHealthCheck(event.getHealthCheckResult().getHealthCheckStrategyUniqueNo(), event.getLastUnhealthTime(), event.getCluster().isClusterHealthy());
    }

    public Class<? extends Event> subscribeType() {
        return HealthCheckResultEvent.class;
    }
}

