/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.api.util.ApplicationUtils;
import com.ovopark.dc.alarm.core.processor.AlarmCheckProcessor;
import com.ovopark.dc.alarm.core.processor.AlarmCheckProcessorDelegate;
import com.ovopark.dc.alarm.core.task.BaseRunnableTask;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTaskReactor;
import com.ovopark.dc.alarm.healthcheck.pojo.Cluster;
import java.io.Serializable;
import org.apache.commons.lang3.RandomUtils;

public class HealthCheckTask
extends BaseRunnableTask
implements Serializable {
    private static final long serialVersionUID = 5966653862697643606L;
    private final AlarmCheckProcessor alarmCheckProcessor;
    private Cluster cluster;
    private long startTimeMs;
    private long checkRtNormalized = -1L;
    private String type;
    private volatile boolean cancelled = false;

    public HealthCheckTask() {
        this(null);
    }

    public HealthCheckTask(Cluster cluster) {
        this.cluster = cluster;
        this.alarmCheckProcessor = (AlarmCheckProcessor)ApplicationUtils.getBean(AlarmCheckProcessorDelegate.class);
        this.initCheckRt();
    }

    private void initCheckRt() {
        this.checkRtNormalized = 2000L + (long)RandomUtils.nextInt((int)0, (int)3000);
    }

    public void run() {
        try {
            this.alarmCheckProcessor.process((Runnable)((Object)this));
            this.setCheckRtNormalized(this.getExecutePeriod());
        }
        catch (Throwable ignored) {
            throw ignored;
        }
        finally {
            if (!this.cancelled) {
                HealthCheckTaskReactor.scheduleCheck(this);
            }
        }
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void setStartTimeMs(long startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    public long getCheckRtNormalized() {
        return this.checkRtNormalized;
    }

    public void setCheckRtNormalized(long checkRtNormalized) {
        this.checkRtNormalized = checkRtNormalized;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AlarmCheckProcessor getAlarmCheckProcessor() {
        return this.alarmCheckProcessor;
    }

    public String toString() {
        return "HealthCheckTask{cluster=" + this.cluster + ", startTimeMs=" + this.startTimeMs + ", checkRtNormalized=" + this.checkRtNormalized + ", type='" + this.type + "', cancelled=" + this.cancelled + "}";
    }
}

