/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckInstance;
import com.ovopark.dc.alarm.api.enums.HealthCheckObjectEnum;
import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.api.enums.StrategyStatusEnum;
import com.ovopark.dc.alarm.api.model.AlarmHealthCheckStrategyWrapper;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTaskDictionary;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTaskReactor;
import com.ovopark.dc.alarm.healthcheck.curl.CurlHealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.pojo.Cluster;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import com.ovopark.dc.alarm.repository.PersistService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckTaskInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckTaskInitializer.class);
    private final PersistService persistService;

    public HealthCheckTaskInitializer(PersistService persistService) {
        this.persistService = persistService;
    }

    protected static void healthCheckInit(AlarmHealthCheckStrategyWrapper wrapper) {
        if (StrategyStatusEnum.STOP.getCode().equals(wrapper.getStatus())) {
            return;
        }
        if (HealthCheckWayEnum.CURL.getCode().equals(wrapper.getCheckWay())) {
            CurlHealthCheckTask task = new CurlHealthCheckTask(wrapper);
            task.setType(HealthCheckWayEnum.matchCode((Integer)wrapper.getCheckWay()).getType());
            task.setUniqueID(wrapper.getUniqueNo());
            task.setExecutePeriod((long)wrapper.getCheckPeriod().intValue() * 1000L);
            HealthCheckTaskReactor.scheduleCheck(task);
            HealthCheckTaskDictionary.registry(wrapper.getUniqueNo(), task);
        }
        if (HealthCheckWayEnum.TCP_SUPER_SENSE.getCode().equals(wrapper.getCheckWay()) || HealthCheckWayEnum.HTTP_REQUEST.getCode().equals(wrapper.getCheckWay())) {
            if (CollectionUtils.isEmpty((Collection)wrapper.getInstances())) {
                return;
            }
            String serviceName = ((AlarmHealthCheckInstance)wrapper.getInstances().get(0)).getApplicationName();
            String clusterName = wrapper.getStrategyName();
            ArrayList<Instance> instanceList = new ArrayList<Instance>();
            wrapper.getInstances().forEach(ip -> {
                Instance instance = Instance.toInstance(ip, HealthCheckObjectEnum.STANDALONE.getCode().equals(wrapper.getCheckObject()), serviceName, clusterName);
                instanceList.add(instance);
            });
            Cluster cluster = new Cluster(HealthCheckObjectEnum.STANDALONE.getCode().equals(wrapper.getCheckObject()), instanceList);
            cluster.setClusterHealthQuota(wrapper.getUnhealthQuota());
            cluster.setCheckPeriod(wrapper.getCheckPeriod());
            cluster.setStrategyUniqueNo(wrapper.getUniqueNo());
            cluster.setClusterName(clusterName);
            cluster.setNotifies(wrapper.getNotifies());
            cluster.setServiceName(serviceName);
            HealthCheckTaskDictionary.registry(wrapper.getUniqueNo(), cluster.init(HealthCheckWayEnum.matchCode((Integer)wrapper.getCheckWay()).getType()));
        }
    }

    @Async
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        log.info("[HealthCheckTaskInitializer] init health check tasks ...");
        List healthCheckStrategies = this.persistService.getHealthCheckStrategy().listAll();
        if (CollectionUtils.isNotEmpty((Collection)healthCheckStrategies)) {
            healthCheckStrategies.forEach(HealthCheckTaskInitializer::healthCheckInit);
        }
    }
}

