/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck;

import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class InstanceStatus {
    private static ConcurrentMap<String, InstanceStatus> statusMap = new ConcurrentHashMap<String, InstanceStatus>();
    public AtomicBoolean isBeingChecked = new AtomicBoolean(false);
    public AtomicInteger checkFailCount = new AtomicInteger(0);
    public AtomicInteger checkOkCount = new AtomicInteger(0);

    public static void reset(Instance instance) {
        statusMap.put(InstanceStatus.buildKey(instance), new InstanceStatus());
    }

    public static InstanceStatus get(Instance instance) {
        String key = InstanceStatus.buildKey(instance);
        if (!statusMap.containsKey(key)) {
            statusMap.putIfAbsent(key, new InstanceStatus());
        }
        return (InstanceStatus)statusMap.get(key);
    }

    protected static void remove(Instance instance) {
        statusMap.remove(InstanceStatus.buildKey(instance));
    }

    private static String buildKey(Instance instance) {
        try {
            String clusterName = instance.getClusterName();
            String serviceName = instance.getServiceName();
            String datumKey = instance.getDatumKey();
            return serviceName + ":" + clusterName + ":" + datumKey;
        }
        catch (Throwable throwable) {
            return instance.getDefaultKey();
        }
    }
}

