/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.curl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckStrategy;
import com.ovopark.dc.alarm.api.enums.CurlExitCodeEnum;
import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.core.processor.AlarmCheckProcessor;
import com.ovopark.dc.alarm.event.notify.UnifiedNotifyCenter;
import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.healthcheck.HealthCheckAlarmEvent;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.curl.CurlHealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.curl.CurlStatusChangeEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CurlHealthCheckProcessor
implements AlarmCheckProcessor<HealthCheckTask> {
    private static final Logger log = LoggerFactory.getLogger(CurlHealthCheckProcessor.class);
    private static final Integer NORMAL_EXIT_CODE = 0;
    private final UnifiedNotifyCenter unifiedNotifyCenter;

    public CurlHealthCheckProcessor(UnifiedNotifyCenter unifiedNotifyCenter) {
        this.unifiedNotifyCenter = unifiedNotifyCenter;
    }

    public String getType() {
        return HealthCheckWayEnum.CURL.getType();
    }

    public void process(HealthCheckTask task) {
        block10: {
            if (task instanceof CurlHealthCheckTask) {
                CurlHealthCheckTask checkTask = (CurlHealthCheckTask)task;
                AlarmHealthCheckStrategy strategy = checkTask.getWrapper().getAlarmHealthCheckStrategy();
                System.out.println("\u6267\u884c == \u4e00\u4e2acurl\u4efb\u52a1==" + strategy.getStrategyName());
                String curl = strategy.getCurlExpress().trim();
                String[] args = curl.split(" ");
                ArrayList<String> handledArgs = new ArrayList<String>();
                Arrays.asList(args).forEach(arg -> {
                    if (arg.startsWith("'") && arg.endsWith("'") && arg.length() > 1) {
                        handledArgs.add(arg.substring(1, arg.length() - 1));
                    } else if (arg.startsWith("\"") && arg.endsWith("\"") && arg.length() > 1) {
                        handledArgs.add(arg.substring(1, arg.length() - 1));
                    } else {
                        handledArgs.add((String)arg);
                    }
                });
                ProcessBuilder processBuilder = new ProcessBuilder(handledArgs);
                try {
                    String result;
                    Process process = processBuilder.start();
                    process.waitFor((long)strategy.getCheckPeriod().intValue() * 1000L, TimeUnit.MILLISECONDS);
                    Integer exit = process.exitValue();
                    if (!NORMAL_EXIT_CODE.equals(exit)) {
                        this.unifiedNotifyCenter.publishEvent((Event)new HealthCheckAlarmEvent(strategy, HealthCheckWayEnum.CURL, "", "", "Curl \u6267\u884c\u5f02\u5e38\uff1a\u9000\u51fa\u7801[ " + exit + " ] == " + CurlExitCodeEnum.getDesc((Integer)exit), checkTask.getWrapper().getNotifies()));
                        this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), false));
                        return;
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((result = bufferedReader.readLine()) != null) {
                        sb.append(result);
                    }
                    if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                        String[] resExpress = this.getExpectCodePlaceholder(strategy.getExpectResponseCodePlaceholder());
                        try {
                            String responseCode = this.getExpectCode(sb.toString(), resExpress);
                            if (!strategy.getExpectResponseCode().equals(responseCode)) {
                                this.unifiedNotifyCenter.publishEvent((Event)new HealthCheckAlarmEvent(strategy, HealthCheckWayEnum.CURL, sb.toString(), responseCode, "", checkTask.getWrapper().getNotifies()));
                                this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), false));
                                break block10;
                            }
                            this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), true));
                        }
                        catch (JSONException e) {
                            this.unifiedNotifyCenter.publishEvent((Event)new HealthCheckAlarmEvent(strategy, HealthCheckWayEnum.CURL, sb.toString(), "\u89e3\u6790\u5931\u8d25", "\u54cd\u5e94\u5f02\u5e38\uff0c\u4e0d\u80fd\u89e3\u6790\u4e3a json \u683c\u5f0f\uff1a" + e.getMessage(), checkTask.getWrapper().getNotifies()));
                            this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), false));
                        }
                        break block10;
                    }
                    this.unifiedNotifyCenter.publishEvent((Event)new HealthCheckAlarmEvent(strategy, HealthCheckWayEnum.CURL, sb.toString(), "", "\u54cd\u5e94\u5f02\u5e38", checkTask.getWrapper().getNotifies()));
                    this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), false));
                }
                catch (IOException ioException) {
                    this.unifiedNotifyCenter.publishEvent((Event)new HealthCheckAlarmEvent(strategy, HealthCheckWayEnum.CURL, "", "\u89e3\u6790\u5931\u8d25", "Curl \u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff1a" + ioException.getMessage(), checkTask.getWrapper().getNotifies()));
                    this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), false));
                }
                catch (InterruptedException e) {
                    this.unifiedNotifyCenter.publishEvent((Event)new HealthCheckAlarmEvent(strategy, HealthCheckWayEnum.CURL, "", "", "Curl \u8bf7\u6c42\u54cd\u5e94\u65f6\u95f4\u8d85\u8fc7\u7b56\u7565\u6267\u884c\u5468\u671f\uff1a" + e.getMessage(), checkTask.getWrapper().getNotifies()));
                    this.unifiedNotifyCenter.publishEvent((Event)new CurlStatusChangeEvent(strategy.getUniqueNo(), false));
                }
            }
        }
    }

    private String[] getExpectCodePlaceholder(String placeholder) {
        if (placeholder.contains(".")) {
            return placeholder.split("\\.");
        }
        return new String[]{placeholder};
    }

    private String getExpectCode(String response, String[] express) throws JSONException {
        JSONObject jsonObject;
        if (StringUtils.isBlank((CharSequence)response)) {
            return null;
        }
        if (express.length == 0) {
            return response;
        }
        JSONObject resTemp = jsonObject = JSONObject.parseObject((String)response);
        for (int i = 0; i < express.length; ++i) {
            Object obj = resTemp.get((Object)express[i]);
            if (!(obj instanceof JSONObject)) {
                return "" + obj;
            }
            resTemp = (JSONObject)obj;
        }
        return "" + resTemp;
    }
}

