/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.http;

import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.core.processor.AlarmCheckProcessor;
import com.ovopark.dc.alarm.healthcheck.HealthCheckCommon;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import com.ovopark.dc.alarm.http.Callback;
import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.Query;
import com.ovopark.dc.alarm.http.RestResult;
import com.ovopark.dc.alarm.http.request.AsyncHttpClientRequest;
import com.ovopark.dc.alarm.http.request.okhttp.OkHttpAsyncClientRequest;
import com.ovopark.dc.alarm.http.template.AsyncRestTemplate;
import com.ovopark.dc.alarm.http.utils.HttpUtils;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpHealthCheckProcessor
implements AlarmCheckProcessor<HealthCheckTask> {
    private static final Logger log = LoggerFactory.getLogger(HttpHealthCheckProcessor.class);
    private static final Long WORST_HTTP_HEALTH_CHECK_RT = 2000L;
    private HealthCheckCommon healthCheckCommon;

    public String getType() {
        return HealthCheckWayEnum.HTTP_REQUEST.getType();
    }

    public void process(HealthCheckTask task) {
        this.healthCheckCommon = HealthCheckCommon.getInstance();
        AsyncRestTemplate restTemplate = new AsyncRestTemplate((AsyncHttpClientRequest)OkHttpAsyncClientRequest.getInstance());
        if (CollectionUtils.isEmpty(task.getCluster().allInstance())) {
            return;
        }
        task.getCluster().allInstance().forEach(instance -> {
            try {
                URL host = new URL("http://" + instance.getIp() + ":" + instance.getPort());
                URL target = new URL(host, instance.getCheckPath());
                HttpHealthCheckCallback callback = new HttpHealthCheckCallback((Instance)instance, task);
                restTemplate.get(target.toString(), Header.EMPTY, Query.EMPTY, String.class, (Callback)callback);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private class HttpHealthCheckCallback
    implements Callback<String> {
        private Instance instance;
        private HealthCheckTask task;
        private long startTime = System.currentTimeMillis();

        public HttpHealthCheckCallback(Instance instance, HealthCheckTask task) {
            this.instance = instance;
            this.task = task;
        }

        public void onReceive(RestResult<String> result) {
            int httpCode;
            this.instance.setCheckRt(System.currentTimeMillis() - this.startTime);
            if (this.instance.getCheckRt() > WORST_HTTP_HEALTH_CHECK_RT) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:timeout:default=" + WORST_HTTP_HEALTH_CHECK_RT);
            }
            if (200 == (httpCode = result.getCode())) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkOK(this.instance, this.task, "http:" + httpCode);
            } else if (503 == httpCode || 302 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:" + httpCode);
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:" + httpCode);
            }
        }

        public void onError(Throwable throwable) {
            this.instance.setCheckRt(System.currentTimeMillis() - this.startTime);
            Throwable cause = throwable;
            int maxStackDepth = 50;
            for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                if (!HttpUtils.isTimeoutException((Throwable)throwable)) continue;
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:timeout:" + cause.getMessage());
                return;
            }
            if (null == throwable) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:unknownError");
                return;
            }
            if (throwable instanceof ConnectException) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:unable2connect:" + throwable.getMessage());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.instance, this.task, "http:error:" + throwable.getMessage());
            }
        }

        public void onCancel() {
        }
    }
}

