/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.pojo;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckNotify;
import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.api.util.ApplicationUtils;
import com.ovopark.dc.alarm.healthcheck.HealthCheckAlarmEvent;
import com.ovopark.dc.alarm.healthcheck.HealthCheckAlarmEventPublisher;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTaskReactor;
import com.ovopark.dc.alarm.healthcheck.InstanceStatus;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class Cluster
implements Serializable {
    private static final Long WORST_HEALTH_CHECK_RT = 5000L;
    private String serviceName;
    private String clusterName;
    private String strategyUniqueNo;
    private Integer checkPeriod;
    private HealthCheckTask healthCheckTask;
    private boolean isStandAlone;
    private Integer clusterHealthQuota = 1;
    private volatile boolean clusterHealthy = true;
    private AtomicInteger alarmSemaphore;
    private Set<Instance> instances = new HashSet<Instance>();
    private Long lastCheckTimeMs = System.currentTimeMillis();
    private Long recentlyUnhealthTimeMs;
    private Set<Instance> unhealthInstances = new HashSet<Instance>();
    private List<AlarmHealthCheckNotify> notifies;
    private volatile boolean inited = false;
    private static final String INDENT = "\n\t\t";
    private static final String SPACE = " ";

    public Cluster(boolean isStandAlone, List<Instance> instances) {
        this.isStandAlone = isStandAlone;
        this.alarmSemaphore = new AtomicInteger(instances.size());
        this.updateInstances(instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkHealth(Instance instance) {
        Cluster cluster = this;
        synchronized (cluster) {
            if (instance.isHealthy()) {
                this.unhealthInstances.remove(instance);
            } else {
                this.unhealthInstances.add(instance);
            }
            this.finishOneHealthCheck(instance);
            if (this.aliveInstancesLessThanThreshold()) {
                this.clusterIsHealth(false);
                this.recentlyUnhealthTimeMs = System.currentTimeMillis();
            } else {
                this.clusterIsHealth(true);
            }
            if (this.reachOneHealthCheckCycle() && !this.isClusterHealthy()) {
                this.doAlarmNotify();
            }
        }
    }

    public void newHealthCheckCycle() {
        this.lastCheckTimeMs = System.currentTimeMillis();
        this.alarmSemaphore.set(this.instances.size());
    }

    private boolean aliveInstancesLessThanThreshold() {
        return this.instances.size() - this.unhealthInstances.size() < this.clusterHealthQuota;
    }

    private boolean reachOneHealthCheckCycle() {
        return this.alarmSemaphore.get() <= 0;
    }

    private void finishOneHealthCheck(Instance instance) {
        if (instance.getLastCheckTimeEndMs() - this.lastCheckTimeMs <= WORST_HEALTH_CHECK_RT) {
            this.alarmSemaphore.getAndDecrement();
        }
    }

    private void doAlarmNotify() {
        HealthCheckAlarmEvent healthCheckAlarmEvent = new HealthCheckAlarmEvent(this, HealthCheckWayEnum.matchType((String)this.getHealthCheckTask().getType()), this.getNotifies());
        HealthCheckAlarmEventPublisher publisher = (HealthCheckAlarmEventPublisher)((Object)ApplicationUtils.getBeanProvider(HealthCheckAlarmEventPublisher.class).getIfAvailable());
        if (Objects.nonNull((Object)publisher)) {
            publisher.publish(healthCheckAlarmEvent);
        }
    }

    public HealthCheckTask init(String taskType) {
        HealthCheckTask task = new HealthCheckTask(this);
        task.setType(taskType);
        task.setUniqueID(this.getStrategyUniqueNo());
        task.setExecutePeriod((long)this.getCheckPeriod().intValue() * 1000L);
        HealthCheckTaskReactor.scheduleCheck(task);
        this.healthCheckTask = task;
        this.inited = true;
        return task;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void setClusterHealthQuota(Integer clusterHealthQuota) {
        if (clusterHealthQuota <= 1) {
            return;
        }
        this.clusterHealthQuota = clusterHealthQuota;
    }

    public boolean isClusterHealthy() {
        return this.clusterHealthy;
    }

    private void clusterIsHealth(boolean health) {
        this.clusterHealthy = health;
    }

    public void addInstance(Instance instance) {
        this.instances.add(instance);
    }

    public Long getLastCheckTimeMs() {
        return this.lastCheckTimeMs;
    }

    public String toString() {
        return "Cluster{serviceName='" + this.serviceName + "', clusterName='" + this.clusterName + "', strategyUniqueNo='" + this.strategyUniqueNo + "', checkPeriod=" + this.checkPeriod + ", isStandAlone=" + this.isStandAlone + ", clusterHealthQuota=" + this.clusterHealthQuota + ", clusterHealthy=" + this.clusterHealthy + ", instances=" + this.instances + ", unhealthInstances=" + this.unhealthInstances + ", notifies=" + this.notifies + ", inited=" + this.inited + "}";
    }

    public void updateInstances(List<Instance> newInstances) {
        List<Instance> oldInstances = this.allInstance();
        if (CollectionUtils.isNotEmpty(oldInstances)) {
            for (Instance instance : oldInstances) {
                Assert.isTrue((!InstanceStatus.get((Instance)instance).isBeingChecked.get() ? 1 : 0) != 0, (String)(instance.getIp() + ":" + instance.getPort() + " is being checked."));
                instance.setHealthy(false);
            }
            this.instances.clear();
        }
        newInstances.forEach(InstanceStatus::reset);
        this.instances.addAll(newInstances);
    }

    public String getErrorInstancesDescription() {
        List<Instance> errorInstances = this.getUnhealthInstances();
        StringBuilder ins = new StringBuilder();
        if (CollectionUtils.isNotEmpty(errorInstances)) {
            errorInstances.forEach(ip -> ins.append(INDENT).append(ip.getInstanceId()).append(SPACE).append("\u3010destination:" + ip.getIp() + ":" + ip.getPort() + "\u3011").append((String)(StringUtils.isNotBlank((CharSequence)ip.getCheckPath()) ? "\u3010path:" + ip.getCheckPath() + "\u3011" : "")).append(SPACE).append("\u3010detail:" + ip.getMetadata().get("result") + "\u3011"));
        }
        return ins.toString();
    }

    public Long getRecentlyUnhealthTimeMs() {
        return this.recentlyUnhealthTimeMs;
    }

    public List<Instance> getUnhealthInstances() {
        return new ArrayList<Instance>(this.unhealthInstances);
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public List<Instance> allInstance() {
        return new ArrayList<Instance>(this.instances);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public HealthCheckTask getHealthCheckTask() {
        return this.healthCheckTask;
    }

    public void setHealthCheckTask(HealthCheckTask healthCheckTask) {
        this.healthCheckTask = healthCheckTask;
    }

    public Set<Instance> getInstances() {
        return this.instances;
    }

    public String getStrategyUniqueNo() {
        return this.strategyUniqueNo;
    }

    public void setStrategyUniqueNo(String strategyUniqueNo) {
        this.strategyUniqueNo = strategyUniqueNo;
    }

    public Integer getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(Integer checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    public List<AlarmHealthCheckNotify> getNotifies() {
        return this.notifies;
    }

    public void setNotifies(List<AlarmHealthCheckNotify> notifies) {
        this.notifies = notifies;
    }
}

