/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckInstance;
import com.ovopark.dc.alarm.api.model.BestAndWorstAlive;
import com.ovopark.dc.alarm.api.model.BestAndWorstRecover;
import com.ovopark.dc.alarm.healthcheck.InstanceStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Instance
implements Serializable {
    private static final long serialVersionUID = -4747309698751566091L;
    private String instanceId;
    private String ip;
    private int port;
    private String checkPath;
    private volatile boolean instanceHealthy = true;
    private boolean isStandAlone = true;
    private String clusterName;
    private String serviceName;
    private long checkRt;
    private Map<String, String> metadata = new HashMap<String, String>();
    private Long lastCheckTimeBeginMs;
    private Long lastCheckTimeEndMs;
    private BestAndWorstAlive alive;
    private BestAndWorstRecover recover;

    public BestAndWorstAlive getAlive() {
        return this.alive;
    }

    public void setAlive(BestAndWorstAlive alive) {
        this.alive = alive;
    }

    public BestAndWorstRecover getRecover() {
        return this.recover;
    }

    public void setRecover(BestAndWorstRecover recover) {
        this.recover = recover;
    }

    public static Instance toInstance(AlarmHealthCheckInstance healthCheckInstance, boolean isStandAlone, String serviceName, String clusterName) {
        Instance instance = new Instance();
        instance.setInstanceId(healthCheckInstance.getInstanceId());
        instance.setCheckPath(healthCheckInstance.getPath());
        instance.setServiceName(serviceName);
        instance.setClusterName(clusterName);
        instance.setStandAlone(isStandAlone);
        instance.setHealthy(true);
        instance.setIp(healthCheckInstance.getPublicIp());
        instance.setPort(healthCheckInstance.getPort());
        return instance;
    }

    public void addMetadata(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>(4);
        }
        this.metadata.put(key, value);
    }

    public long getCheckRt() {
        return this.checkRt;
    }

    public void setCheckRt(long checkRt) {
        this.checkRt = checkRt;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCheckPath() {
        return this.checkPath;
    }

    public void setCheckPath(String checkPath) {
        this.checkPath = checkPath;
    }

    public boolean isHealthy() {
        return this.instanceHealthy;
    }

    public void setHealthy(boolean healthy) {
        this.instanceHealthy = healthy;
    }

    public void addCheckOkCount() {
        InstanceStatus.get((Instance)this).checkOkCount.getAndIncrement();
    }

    public void addCheckFailCount() {
        InstanceStatus.get((Instance)this).checkFailCount.getAndIncrement();
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public void setStandAlone(boolean isStandAlone) {
        this.isStandAlone = isStandAlone;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    public String getDatumKey() {
        if (this.getPort() > 0) {
            return this.getIp() + ":" + this.getPort() + ":unknown:" + this.getClusterName();
        }
        return this.getIp() + ":unknown:" + this.getClusterName();
    }

    @JsonIgnore
    public String getDefaultKey() {
        if (this.getPort() > 0) {
            return this.getIp() + ":" + this.getPort() + ":unknown";
        }
        return this.getIp() + ":unknown";
    }

    public boolean isBeingChecked() {
        return InstanceStatus.get((Instance)this).isBeingChecked.get();
    }

    public void setBeingChecked(boolean isBeingChecked) {
        if (!isBeingChecked) {
            this.lastCheckTimeEndMs = System.currentTimeMillis();
        }
        InstanceStatus.get((Instance)this).isBeingChecked.set(isBeingChecked);
    }

    public boolean markChecking() {
        this.lastCheckTimeBeginMs = System.currentTimeMillis();
        return InstanceStatus.get((Instance)this).isBeingChecked.compareAndSet(false, true);
    }

    public String toString() {
        return "Instance{instanceId='" + this.instanceId + "', ip='" + this.ip + "', port=" + this.port + ", checkPath='" + this.checkPath + "', healthy=" + this.instanceHealthy + ", isStandAlone=" + this.isStandAlone + ", clusterName='" + this.clusterName + "', serviceName='" + this.serviceName + "', checkRt=" + this.checkRt + ", metadata=" + this.metadata + "}";
    }

    public Long getLastCheckTimeBeginMs() {
        return this.lastCheckTimeBeginMs;
    }

    public Long getLastCheckTimeEndMs() {
        return this.lastCheckTimeEndMs;
    }
}

