/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.tcp;

import com.ovopark.dc.alarm.api.util.ApplicationUtils;
import com.ovopark.dc.alarm.healthcheck.HealthCheckCommon;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import com.ovopark.dc.alarm.healthcheck.tcp.BeatKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Beat {
    long startTimeMs = System.currentTimeMillis();
    private Instance instance;
    private HealthCheckTask task;
    private Map<String, BeatKey> keyMap;
    private HealthCheckCommon healthCheckCommon;

    public Beat(Instance instance, HealthCheckTask task, Map<String, BeatKey> keyMap) {
        this.instance = instance;
        this.task = task;
        this.keyMap = keyMap;
        this.healthCheckCommon = (HealthCheckCommon)((Object)ApplicationUtils.getBean(HealthCheckCommon.class));
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void setStartTimeMs(long startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public Map<String, BeatKey> getKeyMap() {
        return this.keyMap;
    }

    public HealthCheckTask getTask() {
        return this.task;
    }

    public void setTask(HealthCheckTask task) {
        this.task = task;
    }

    public boolean isHealthy() {
        return System.currentTimeMillis() - this.startTimeMs < TimeUnit.SECONDS.toMillis(30L);
    }

    public void finishCheck() {
        this.instance.setBeingChecked(false);
    }

    public void finishCheck(boolean success, String msg) {
        this.instance.setCheckRt(System.currentTimeMillis() - this.startTimeMs);
        if (success) {
            this.healthCheckCommon.checkOK(this.instance, this.task, msg);
        } else {
            this.healthCheckCommon.checkFail(this.instance, this.task, msg);
            this.keyMap.remove(this.task.toString());
        }
    }

    public String toString() {
        return this.task.getCluster().getServiceName() + ":" + this.task.getCluster().getClusterName() + ":" + this.instance.getIp() + ":" + this.instance.getPort();
    }
}

