/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.tcp;

import com.ovopark.dc.alarm.core.executor.GlobalExecutor;
import com.ovopark.dc.alarm.healthcheck.pojo.Cluster;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import com.ovopark.dc.alarm.healthcheck.tcp.Beat;
import com.ovopark.dc.alarm.healthcheck.tcp.BeatKey;
import com.ovopark.dc.alarm.healthcheck.tcp.TimeOutTask;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class PortConnectionTaskProcessor
implements Callable<Void> {
    private Beat beat;
    private Map<String, BeatKey> keyMap;
    private Selector selector;

    public PortConnectionTaskProcessor(Selector selector, Beat beat, Map<String, BeatKey> keyMap) {
        this.beat = beat;
        this.keyMap = keyMap;
        this.selector = selector;
    }

    @Override
    public Void call() throws Exception {
        block6: {
            AbstractInterruptibleChannel channel = null;
            try {
                Instance instance = this.beat.getInstance();
                BeatKey beatKey = this.keyMap.get(this.beat.toString());
                if (beatKey != null && beatKey.key.isValid()) {
                    if (System.currentTimeMillis() - beatKey.birthTime < 0L) {
                        instance.setBeingChecked(false);
                        return null;
                    }
                    beatKey.key.cancel();
                    beatKey.key.channel().close();
                }
                channel = SocketChannel.open();
                ((AbstractSelectableChannel)channel).configureBlocking(false);
                ((SocketChannel)channel).socket().setSoLinger(false, -1);
                ((SocketChannel)channel).socket().setReuseAddress(true);
                ((SocketChannel)channel).socket().setKeepAlive(true);
                ((SocketChannel)channel).socket().setTcpNoDelay(true);
                Cluster cluster = this.beat.getTask().getCluster();
                int port = instance.getPort();
                ((SocketChannel)channel).connect(new InetSocketAddress(instance.getIp(), port));
                SelectionKey key = ((SelectableChannel)channel).register(this.selector, 9);
                key.attach(this.beat);
                this.keyMap.put(this.beat.toString(), new BeatKey(key));
                this.beat.setStartTimeMs(System.currentTimeMillis());
                GlobalExecutor.scheduleTcpDetectionTask((Runnable)new TimeOutTask(key), (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.beat.finishCheck(false, "tcp:error:" + e.getMessage());
                if (channel == null) break block6;
                try {
                    channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

