/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.tcp;

import com.ovopark.dc.alarm.healthcheck.tcp.Beat;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class SelectedKeyPostProcessor
implements Runnable {
    SelectionKey key;

    public SelectedKeyPostProcessor(SelectionKey key) {
        this.key = key;
    }

    @Override
    public void run() {
        Beat beat = (Beat)this.key.attachment();
        SocketChannel channel = (SocketChannel)this.key.channel();
        try {
            ByteBuffer buffer;
            if (!beat.isHealthy()) {
                this.key.cancel();
                this.key.channel().close();
                beat.finishCheck();
                return;
            }
            if (this.key.isValid() && this.key.isConnectable()) {
                channel.finishConnect();
                beat.finishCheck(true, "tcp:ok+");
            }
            if (this.key.isValid() && this.key.isReadable() && channel.read(buffer = ByteBuffer.allocate(128)) == -1) {
                this.key.cancel();
                this.key.channel().close();
            }
        }
        catch (ConnectException e) {
            beat.finishCheck(false, "tcp:unable2connect:" + e.getMessage());
        }
        catch (Exception e) {
            beat.finishCheck(false, "tcp:error:" + e.getMessage());
            try {
                this.key.cancel();
                this.key.channel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

