/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.healthcheck.tcp;

import com.ovopark.dc.alarm.api.enums.HealthCheckWayEnum;
import com.ovopark.dc.alarm.api.util.ApplicationUtils;
import com.ovopark.dc.alarm.core.executor.GlobalExecutor;
import com.ovopark.dc.alarm.core.processor.AlarmCheckProcessor;
import com.ovopark.dc.alarm.healthcheck.HealthCheckTask;
import com.ovopark.dc.alarm.healthcheck.pojo.Instance;
import com.ovopark.dc.alarm.healthcheck.tcp.Beat;
import com.ovopark.dc.alarm.healthcheck.tcp.BeatKey;
import com.ovopark.dc.alarm.healthcheck.tcp.PortConnectionTaskProcessor;
import com.ovopark.dc.alarm.healthcheck.tcp.SelectedKeyPostProcessor;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TcpDetectionHealthCheckProcessor
implements AlarmCheckProcessor<HealthCheckTask>,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(TcpDetectionHealthCheckProcessor.class);
    protected static final int CONNECT_TIMEOUT_MS = 1000;
    protected static final long TCP_KEEP_ALIVE_MILLIS = 0L;
    protected static final int NIO_THREAD_COUNT = Runtime.getRuntime().availableProcessors() <= 1 ? 1 : Runtime.getRuntime().availableProcessors() / 2;
    private final BlockingQueue<Beat> taskQueue = new LinkedBlockingQueue<Beat>();
    private final Map<String, BeatKey> keyMap = new ConcurrentHashMap<String, BeatKey>();
    private Selector selector;

    public TcpDetectionHealthCheckProcessor() {
        try {
            this.selector = Selector.open();
            GlobalExecutor.submitTcpCheck((Runnable)this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while init TcpDetectionHealthCheckProcessor.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                log.error("[TcpDetectionHealthCheckProcessor] hook execute error : {}.", (Object)e.getMessage());
            }
        }));
    }

    public static TcpDetectionHealthCheckProcessor getInstance() {
        return (TcpDetectionHealthCheckProcessor)ApplicationUtils.getBeanProvider(TcpDetectionHealthCheckProcessor.class).getIfAvailable();
    }

    public Selector applySelector() {
        return this.selector;
    }

    public String getType() {
        return HealthCheckWayEnum.TCP_SUPER_SENSE.getType();
    }

    public void process(HealthCheckTask task) {
        List<Instance> instances = task.getCluster().allInstance();
        task.getCluster().newHealthCheckCycle();
        if (CollectionUtils.isNotEmpty(instances)) {
            for (Instance instance : instances) {
                if (instance.isBeingChecked()) continue;
                if (!instance.markChecking()) {
                    log.warn("tcp check started before last one finished, service: " + task.getCluster().getServiceName() + ":" + task.getCluster().getClusterName() + ":" + instance.getIp() + ":" + instance.getPort());
                }
                this.taskQueue.add(new Beat(instance, task, this.keyMap));
            }
        }
    }

    private void processBeatTask() throws Exception {
        LinkedList<PortConnectionTaskProcessor> tasks = new LinkedList<PortConnectionTaskProcessor>();
        do {
            Beat beat;
            if ((beat = this.taskQueue.poll(500L, TimeUnit.MILLISECONDS)) == null) {
                return;
            }
            tasks.add(new PortConnectionTaskProcessor(this.selector, beat, this.keyMap));
        } while (this.taskQueue.size() > 0 && tasks.size() < NIO_THREAD_COUNT * 64);
        for (Future f : GlobalExecutor.invokeAllTcpDetectionTask(tasks)) {
            f.get();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.processBeatTask();
                    readyChannelCount = this.selector.selectNow();
                    if (readyChannelCount <= 0) continue;
                    selectionKeyIterator = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (selectionKeyIterator.hasNext()) ** break;
                        continue block3;
                        key = selectionKeyIterator.next();
                        selectionKeyIterator.remove();
                        GlobalExecutor.executeTcpDetectionTask((Runnable)new SelectedKeyPostProcessor(key));
                    }
                    break;
                }
            }
            catch (Throwable var1_2) {
                continue;
            }
            break;
        }
    }
}

