/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CollectRep {

    public static final class ValueRow
    implements ValueRowOrBuilder {
        private static final ValueRow DEFAULT_INSTANCE = new ValueRow();
        private List<String> columns = new ArrayList<String>();

        @Override
        public List<String> getColumnsList() {
            return this.columns;
        }

        @Override
        public int getColumnsCount() {
            return this.columns.size();
        }

        @Override
        public String getColumns(int index) {
            return this.columns.get(index);
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ValueRow prototype) {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public Builder toBuilder() {
            return new Builder();
        }

        public static final class Builder
        implements ValueRowOrBuilder {
            private List<String> columns = new ArrayList<String>();

            public ValueRow build() {
                ValueRow result = new ValueRow();
                result.columns = this.columns;
                return result;
            }

            @Override
            public List<String> getColumnsList() {
                return this.columns;
            }

            @Override
            public int getColumnsCount() {
                return this.columns.size();
            }

            @Override
            public String getColumns(int index) {
                return this.columns.get(index);
            }

            public Builder setColumns(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                if (index >= this.columns.size()) {
                    throw new IllegalArgumentException("\u6700\u5927\u53ef\u64cd\u4f5c index=" + (this.columns.size() - 1));
                }
                this.columns.set(index, value);
                return this;
            }

            public Builder addColumns(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.columns.add(value);
                return this;
            }

            public Builder addAllColumns(Iterable<String> values) {
                Iterator<String> iterator = values.iterator();
                while (iterator.hasNext()) {
                    this.columns.add(iterator.next());
                }
                return this;
            }

            public Builder clearColumns() {
                this.columns = new ArrayList<String>();
                return this;
            }
        }
    }

    public static interface ValueRowOrBuilder {
        public List<String> getColumnsList();

        public int getColumnsCount();

        public String getColumns(int var1);
    }

    public static final class Field
    implements FieldOrBuilder {
        private String name;
        private int type;
        private boolean label;
        private String unit;
        private static final Field DEFAULT_INSTANCE = new Field();

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getUnit() {
            return this.unit;
        }

        @Override
        public boolean getLabel() {
            return this.label;
        }

        public Builder newBuilderForType() {
            return Field.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Field prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        public static Field getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public Field getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        implements FieldOrBuilder {
            private String name = "";
            private int type;
            private String unit = "";
            private boolean label;

            public Field build() {
                Field result = new Field();
                result.name = this.name;
                result.type = this.type;
                result.unit = this.unit;
                result.label = this.label;
                return result;
            }

            public Builder mergeFrom(Field other) {
                if (other == Field.getDefaultInstance()) {
                    return this;
                }
                if (!other.getName().isEmpty()) {
                    this.name = other.name;
                }
                if (other.getType() != 0) {
                    this.setType(other.getType());
                }
                if (!other.getUnit().isEmpty()) {
                    this.unit = other.unit;
                }
                if (other.getLabel()) {
                    this.setLabel(other.getLabel());
                }
                return this;
            }

            @Override
            public String getName() {
                return this.name;
            }

            public Builder setName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.name = value;
                return this;
            }

            @Override
            public int getType() {
                return this.type;
            }

            public Builder setType(int value) {
                this.type = value;
                return this;
            }

            @Override
            public String getUnit() {
                return this.unit;
            }

            public Builder setUnit(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.unit = value;
                return this;
            }

            @Override
            public boolean getLabel() {
                return this.label;
            }

            public Builder setLabel(boolean value) {
                this.label = value;
                return this;
            }
        }
    }

    public static interface FieldOrBuilder {
        public String getName();

        public int getType();

        public String getUnit();

        public boolean getLabel();
    }

    public static final class MetricsData
    implements MetricsDataOrBuilder {
        private static final MetricsData DEFAULT_INSTANCE = new MetricsData();
        private long time;
        private long id;
        private int code;
        private String msg;
        private long tenantId;
        private String app;
        private String metrics;
        private int priority;
        private List<Field> fields;
        private List<ValueRow> values;

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public long getTenantId() {
            return this.tenantId;
        }

        @Override
        public String getApp() {
            return this.app;
        }

        @Override
        public String getMetrics() {
            return this.metrics;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public int getCodeValue() {
            return this.code;
        }

        @Override
        public Code getCode() {
            Code result = Code.valueOf(this.code);
            return result == null ? Code.UNRECOGNIZED : result;
        }

        @Override
        public String getMsg() {
            return this.msg;
        }

        @Override
        public List<Field> getFieldsList() {
            return this.fields;
        }

        @Override
        public List<? extends FieldOrBuilder> getFieldsOrBuilderList() {
            return this.fields;
        }

        @Override
        public int getFieldsCount() {
            return this.fields.size();
        }

        @Override
        public Field getFields(int index) {
            return this.fields.get(index);
        }

        @Override
        public FieldOrBuilder getFieldsOrBuilder(int index) {
            return this.fields.get(index);
        }

        @Override
        public List<ValueRow> getValuesList() {
            return this.values;
        }

        @Override
        public List<? extends ValueRowOrBuilder> getValuesOrBuilderList() {
            return this.values;
        }

        @Override
        public int getValuesCount() {
            return this.values.size();
        }

        @Override
        public ValueRow getValues(int index) {
            return this.values.get(index);
        }

        @Override
        public ValueRowOrBuilder getValuesOrBuilder(int index) {
            return this.values.get(index);
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public Builder toBuilder() {
            return new Builder();
        }

        public static MetricsData getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        implements MetricsDataOrBuilder {
            private long id;
            private String metrics = "";
            private int priority;
            private long tenantId;
            private String app = "";
            private long time;
            private int code = 0;
            private String msg = "";
            private List<Field> fields = Collections.emptyList();
            private List<ValueRow> values = Collections.emptyList();

            public MetricsData build() {
                MetricsData result = new MetricsData();
                result.id = this.id;
                result.tenantId = this.tenantId;
                result.app = this.app;
                result.metrics = this.metrics;
                result.priority = this.priority;
                result.time = this.time;
                result.code = this.code;
                result.msg = this.msg;
                result.fields = this.fields;
                result.values = this.values;
                return result;
            }

            @Override
            public long getId() {
                return this.id;
            }

            public Builder setId(long value) {
                this.id = value;
                return this;
            }

            public Builder clearId() {
                this.id = 0L;
                return this;
            }

            @Override
            public long getTenantId() {
                return this.tenantId;
            }

            public Builder setTenantId(long value) {
                this.tenantId = value;
                return this;
            }

            public Builder clearTenantId() {
                this.tenantId = 0L;
                return this;
            }

            @Override
            public String getApp() {
                return this.app;
            }

            public Builder setApp(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.app = value;
                return this;
            }

            public Builder clearApp() {
                this.app = MetricsData.getDefaultInstance().getApp();
                return this;
            }

            @Override
            public String getMetrics() {
                return this.metrics;
            }

            public Builder setMetrics(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.metrics = value;
                return this;
            }

            public Builder clearMetrics() {
                this.metrics = MetricsData.getDefaultInstance().getMetrics();
                return this;
            }

            @Override
            public int getPriority() {
                return this.priority;
            }

            public Builder setPriority(int value) {
                this.priority = value;
                return this;
            }

            public Builder clearPriority() {
                this.priority = 0;
                return this;
            }

            @Override
            public long getTime() {
                return this.time;
            }

            public Builder setTime(long value) {
                this.time = value;
                return this;
            }

            public Builder clearTime() {
                this.time = 0L;
                return this;
            }

            @Override
            public int getCodeValue() {
                return this.code;
            }

            public Builder setCodeValue(int value) {
                this.code = value;
                return this;
            }

            @Override
            public Code getCode() {
                Code result = Code.valueOf(this.code);
                return result == null ? Code.UNRECOGNIZED : result;
            }

            public Builder setCode(Code value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.code = value.getNumber();
                return this;
            }

            public Builder clearCode() {
                this.code = 0;
                return this;
            }

            @Override
            public String getMsg() {
                return this.msg;
            }

            public Builder setMsg(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.msg = value;
                return this;
            }

            public Builder clearMsg() {
                this.msg = MetricsData.getDefaultInstance().getMsg();
                return this;
            }

            @Override
            public List<Field> getFieldsList() {
                return Collections.unmodifiableList(this.fields);
            }

            @Override
            public int getFieldsCount() {
                return this.fields.size();
            }

            @Override
            public Field getFields(int index) {
                return this.fields.get(index);
            }

            public Builder setFields(int index, Field value) {
                this.fields.set(index, value);
                return this;
            }

            public Builder setFields(int index, Field.Builder builderForValue) {
                this.fields.set(index, builderForValue.build());
                return this;
            }

            public Builder addFields(Field value) {
                this.fields.add(value);
                return this;
            }

            public Builder addFields(int index, Field value) {
                this.fields.add(index, value);
                return this;
            }

            public Builder addFields(Field.Builder builderForValue) {
                this.fields.add(builderForValue.build());
                return this;
            }

            public Builder addFields(int index, Field.Builder builderForValue) {
                this.fields.add(index, builderForValue.build());
                return this;
            }

            public Builder addAllFields(Iterable<? extends Field> values) {
                return this;
            }

            public Builder clearFields() {
                this.fields = Collections.emptyList();
                return this;
            }

            public Builder removeFields(int index) {
                this.fields.remove(index);
                return this;
            }

            @Override
            public FieldOrBuilder getFieldsOrBuilder(int index) {
                return this.fields.get(index);
            }

            @Override
            public List<? extends FieldOrBuilder> getFieldsOrBuilderList() {
                return Collections.unmodifiableList(this.fields);
            }

            private void ensureValuesIsMutable() {
                this.values = new ArrayList<ValueRow>(this.values);
            }

            @Override
            public List<ValueRow> getValuesList() {
                return Collections.unmodifiableList(this.values);
            }

            @Override
            public int getValuesCount() {
                return this.values.size();
            }

            @Override
            public ValueRow getValues(int index) {
                return this.values.get(index);
            }

            public Builder setValues(int index, ValueRow value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureValuesIsMutable();
                this.values.set(index, value);
                return this;
            }

            public Builder setValues(int index, ValueRow.Builder builderForValue) {
                this.ensureValuesIsMutable();
                this.values.set(index, builderForValue.build());
                return this;
            }

            public Builder addValues(ValueRow value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureValuesIsMutable();
                this.values.add(value);
                return this;
            }

            public Builder addValues(int index, ValueRow value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureValuesIsMutable();
                this.values.add(index, value);
                return this;
            }

            public Builder addValues(ValueRow.Builder builderForValue) {
                this.ensureValuesIsMutable();
                this.values.add(builderForValue.build());
                return this;
            }

            public Builder addValues(int index, ValueRow.Builder builderForValue) {
                this.ensureValuesIsMutable();
                this.values.add(index, builderForValue.build());
                return this;
            }

            public Builder addAllValues(Iterable<? extends ValueRow> values) {
                this.ensureValuesIsMutable();
                return this;
            }

            public Builder clearValues() {
                this.values = Collections.emptyList();
                return this;
            }

            public Builder removeValues(int index) {
                this.ensureValuesIsMutable();
                this.values.remove(index);
                return this;
            }

            @Override
            public ValueRowOrBuilder getValuesOrBuilder(int index) {
                return this.values.get(index);
            }

            @Override
            public List<? extends ValueRowOrBuilder> getValuesOrBuilderList() {
                return Collections.unmodifiableList(this.values);
            }
        }
    }

    public static interface MetricsDataOrBuilder {
        public long getId();

        public long getTenantId();

        public String getApp();

        public String getMetrics();

        public int getPriority();

        public long getTime();

        public int getCodeValue();

        public Code getCode();

        public String getMsg();

        public List<Field> getFieldsList();

        public Field getFields(int var1);

        public int getFieldsCount();

        public List<? extends FieldOrBuilder> getFieldsOrBuilderList();

        public FieldOrBuilder getFieldsOrBuilder(int var1);

        public List<ValueRow> getValuesList();

        public ValueRow getValues(int var1);

        public int getValuesCount();

        public List<? extends ValueRowOrBuilder> getValuesOrBuilderList();

        public ValueRowOrBuilder getValuesOrBuilder(int var1);
    }

    public static enum Code {
        SUCCESS(0),
        UN_AVAILABLE(1),
        UN_REACHABLE(2),
        UN_CONNECTABLE(3),
        FAIL(4),
        TIMEOUT(5),
        UNRECOGNIZED(-1);

        public static final int SUCCESS_VALUE = 0;
        public static final int UN_AVAILABLE_VALUE = 1;
        public static final int UN_REACHABLE_VALUE = 2;
        public static final int UN_CONNECTABLE_VALUE = 3;
        public static final int FAIL_VALUE = 4;
        public static final int TIMEOUT_VALUE = 5;
        private static final Code[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Code valueOf(int value) {
            return Code.forNumber(value);
        }

        public static Code forNumber(int value) {
            switch (value) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return UN_AVAILABLE;
                }
                case 2: {
                    return UN_REACHABLE;
                }
                case 3: {
                    return UN_CONNECTABLE;
                }
                case 4: {
                    return FAIL;
                }
                case 5: {
                    return TIMEOUT;
                }
            }
            return null;
        }

        private Code(int value) {
            this.value = value;
        }

        static {
            VALUES = Code.values();
        }
    }
}

