/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.protocol;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.ovopark.dc.alarm.protocol.AbstractConnection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCommonCache<T, C extends AbstractConnection<?>> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionCommonCache.class);
    private static final long DEFAULT_CACHE_TIMEOUT = 200000L;
    private static final int DEFAULT_MAX_CAPACITY = 10000;
    private static final int CACHE_TIME_LENGTH = 2;
    private Map<T, Long[]> timeoutMap;
    private ConcurrentLinkedHashMap<T, C> cacheMap;
    private ThreadPoolExecutor timeoutCleanerExecutor;

    public ConnectionCommonCache() {
        this.init();
    }

    private void init() {
        this.cacheMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).listener((key, value) -> {
            this.timeoutMap.remove(key);
            try {
                value.close();
            }
            catch (Exception e) {
                log.error("connection close error: {}.", (Object)e.getMessage(), (Object)e);
            }
            log.info("connection common cache discard key: {}, value: {}.", key, value);
        }).build();
        this.timeoutMap = new ConcurrentHashMap<T, Long[]>(156);
        this.timeoutCleanerExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), r -> new Thread(r, "connection-cache-timeout-cleaner"), new ThreadPoolExecutor.DiscardOldestPolicy());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("connection-cache-ava-detector-%d").setDaemon(true).build();
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        scheduledExecutor.scheduleWithFixedDelay(this::detectCacheAvailable, 2L, 20L, TimeUnit.MINUTES);
    }

    private void detectCacheAvailable() {
        try {
            this.cacheMap.forEach((key, value) -> {
                Long[] cacheTime = this.timeoutMap.get(key);
                long currentTime = System.currentTimeMillis();
                if (cacheTime == null || cacheTime.length != 2 || cacheTime[0] + cacheTime[1] < currentTime) {
                    this.cacheMap.remove(key);
                    this.timeoutMap.remove(key);
                    try {
                        value.close();
                    }
                    catch (Exception e) {
                        log.error("connection close error: {}.", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("connection common cache detect cache available error: {}.", (Object)e.getMessage(), (Object)e);
        }
    }

    private void cleanTimeoutCache() {
        try {
            this.cacheMap.forEach((key, value) -> {
                Long[] cacheTime = this.timeoutMap.get(key);
                long currentTime = System.currentTimeMillis();
                if (cacheTime == null || cacheTime.length != 2) {
                    this.timeoutMap.put(key, new Long[]{currentTime, 200000L});
                } else if (cacheTime[0] + cacheTime[1] < currentTime) {
                    log.warn("[connection common cache] clean the timeout cache, key {}", key);
                    this.timeoutMap.remove(key);
                    this.cacheMap.remove(key);
                    try {
                        value.close();
                    }
                    catch (Exception e) {
                        log.error("connection close error: {}.", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
            Thread.sleep(20000L);
        }
        catch (Exception e) {
            log.error("[connection common cache] clean timeout cache error: {}.", (Object)e.getMessage(), (Object)e);
        }
    }

    public void addCache(T key, C value, Long timeDiff) {
        this.removeCache(key);
        if (timeDiff == null) {
            timeDiff = 200000L;
        }
        this.cacheMap.put(key, value);
        this.timeoutMap.put(key, new Long[]{System.currentTimeMillis(), timeDiff});
        this.timeoutCleanerExecutor.execute(this::cleanTimeoutCache);
    }

    public void addCache(T key, C value) {
        this.addCache(key, value, 200000L);
    }

    public Optional<C> getCache(T key, boolean refreshCache) {
        Long[] cacheTime = this.timeoutMap.get(key);
        if (cacheTime == null || cacheTime.length != 2) {
            log.info("[connection common cache] not hit the cache, key {}.", key);
            return Optional.empty();
        }
        if (cacheTime[0] + cacheTime[1] < System.currentTimeMillis()) {
            log.warn("[connection common cache] is timeout, remove it, key {}.", key);
            this.timeoutMap.remove(key);
            this.cacheMap.remove(key);
            return Optional.empty();
        }
        AbstractConnection value = (AbstractConnection)this.cacheMap.get(key);
        if (value == null) {
            log.error("[connection common cache] value is null, remove it, key {}.", key);
            this.cacheMap.remove(key);
            this.timeoutMap.remove(key);
        } else if (refreshCache) {
            cacheTime[0] = System.currentTimeMillis();
            this.timeoutMap.put(key, cacheTime);
        }
        return Optional.ofNullable(value);
    }

    public void removeCache(T key) {
        this.timeoutMap.remove(key);
        AbstractConnection value = (AbstractConnection)this.cacheMap.remove(key);
        try {
            value.close();
        }
        catch (Exception e) {
            log.error("connection close error: {}.", (Object)e.getMessage(), (Object)e);
        }
    }
}

