/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.protocol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.dc.alarm.protocol.CollectRep;
import com.ovopark.dc.alarm.protocol.protocol.FtpProtocol;
import com.ovopark.dc.alarm.protocol.protocol.PrometheusProtocol;
import com.ovopark.dc.alarm.protocol.protocol.SshProtocol;
import com.ovopark.dc.alarm.protocol.protocol.TelnetProtocol;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    private String name;
    private Map<String, String> i18n;
    private String protocol;
    private Byte priority;
    private boolean visible = true;
    private List<Field> fields;
    private List<String> aliasFields;
    private List<String> calculates;
    private List<String> units;
    private TelnetProtocol telnet;
    private SshProtocol ssh;
    private FtpProtocol ftp;
    private PrometheusProtocol prometheus;
    @JsonIgnore
    private transient AtomicReference<CollectRep.MetricsData> subTaskDataRef;
    @JsonIgnore
    private transient AtomicInteger subTaskNum;
    @JsonIgnore
    private transient Integer subTaskId;

    public boolean isHasSubTask() {
        return this.subTaskNum != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metrics metrics = (Metrics)o;
        return this.name.equals(metrics.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static MetricsBuilder builder() {
        return new MetricsBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getI18n() {
        return this.i18n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Byte getPriority() {
        return this.priority;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<String> getAliasFields() {
        return this.aliasFields;
    }

    public List<String> getCalculates() {
        return this.calculates;
    }

    public List<String> getUnits() {
        return this.units;
    }

    public TelnetProtocol getTelnet() {
        return this.telnet;
    }

    public SshProtocol getSsh() {
        return this.ssh;
    }

    public FtpProtocol getFtp() {
        return this.ftp;
    }

    public PrometheusProtocol getPrometheus() {
        return this.prometheus;
    }

    public AtomicReference<CollectRep.MetricsData> getSubTaskDataRef() {
        return this.subTaskDataRef;
    }

    public AtomicInteger getSubTaskNum() {
        return this.subTaskNum;
    }

    public Integer getSubTaskId() {
        return this.subTaskId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setI18n(Map<String, String> i18n) {
        this.i18n = i18n;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPriority(Byte priority) {
        this.priority = priority;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setAliasFields(List<String> aliasFields) {
        this.aliasFields = aliasFields;
    }

    public void setCalculates(List<String> calculates) {
        this.calculates = calculates;
    }

    public void setUnits(List<String> units) {
        this.units = units;
    }

    public void setTelnet(TelnetProtocol telnet) {
        this.telnet = telnet;
    }

    public void setSsh(SshProtocol ssh) {
        this.ssh = ssh;
    }

    public void setFtp(FtpProtocol ftp) {
        this.ftp = ftp;
    }

    public void setPrometheus(PrometheusProtocol prometheus) {
        this.prometheus = prometheus;
    }

    @JsonIgnore
    public void setSubTaskDataRef(AtomicReference<CollectRep.MetricsData> subTaskDataRef) {
        this.subTaskDataRef = subTaskDataRef;
    }

    @JsonIgnore
    public void setSubTaskNum(AtomicInteger subTaskNum) {
        this.subTaskNum = subTaskNum;
    }

    @JsonIgnore
    public void setSubTaskId(Integer subTaskId) {
        this.subTaskId = subTaskId;
    }

    public String toString() {
        return "Metrics(name=" + this.getName() + ", i18n=" + this.getI18n() + ", protocol=" + this.getProtocol() + ", priority=" + this.getPriority() + ", visible=" + this.isVisible() + ", fields=" + this.getFields() + ", aliasFields=" + this.getAliasFields() + ", calculates=" + this.getCalculates() + ", units=" + this.getUnits() + ", telnet=" + this.getTelnet() + ", ssh=" + this.getSsh() + ", ftp=" + this.getFtp() + ", prometheus=" + this.getPrometheus() + ", subTaskDataRef=" + this.getSubTaskDataRef() + ", subTaskNum=" + this.getSubTaskNum() + ", subTaskId=" + this.getSubTaskId() + ")";
    }

    public Metrics(String name, Map<String, String> i18n, String protocol, Byte priority, boolean visible, List<Field> fields, List<String> aliasFields, List<String> calculates, List<String> units, TelnetProtocol telnet, SshProtocol ssh, FtpProtocol ftp, PrometheusProtocol prometheus, AtomicReference<CollectRep.MetricsData> subTaskDataRef, AtomicInteger subTaskNum, Integer subTaskId) {
        this.name = name;
        this.i18n = i18n;
        this.protocol = protocol;
        this.priority = priority;
        this.visible = visible;
        this.fields = fields;
        this.aliasFields = aliasFields;
        this.calculates = calculates;
        this.units = units;
        this.telnet = telnet;
        this.ssh = ssh;
        this.ftp = ftp;
        this.prometheus = prometheus;
        this.subTaskDataRef = subTaskDataRef;
        this.subTaskNum = subTaskNum;
        this.subTaskId = subTaskId;
    }

    public Metrics() {
    }

    public static class MetricsBuilder {
        private String name;
        private Map<String, String> i18n;
        private String protocol;
        private Byte priority;
        private boolean visible;
        private List<Field> fields;
        private List<String> aliasFields;
        private List<String> calculates;
        private List<String> units;
        private TelnetProtocol telnet;
        private SshProtocol ssh;
        private FtpProtocol ftp;
        private PrometheusProtocol prometheus;
        private AtomicReference<CollectRep.MetricsData> subTaskDataRef;
        private AtomicInteger subTaskNum;
        private Integer subTaskId;

        MetricsBuilder() {
        }

        public MetricsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricsBuilder i18n(Map<String, String> i18n) {
            this.i18n = i18n;
            return this;
        }

        public MetricsBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public MetricsBuilder priority(Byte priority) {
            this.priority = priority;
            return this;
        }

        public MetricsBuilder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public MetricsBuilder fields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public MetricsBuilder aliasFields(List<String> aliasFields) {
            this.aliasFields = aliasFields;
            return this;
        }

        public MetricsBuilder calculates(List<String> calculates) {
            this.calculates = calculates;
            return this;
        }

        public MetricsBuilder units(List<String> units) {
            this.units = units;
            return this;
        }

        public MetricsBuilder telnet(TelnetProtocol telnet) {
            this.telnet = telnet;
            return this;
        }

        public MetricsBuilder ssh(SshProtocol ssh) {
            this.ssh = ssh;
            return this;
        }

        public MetricsBuilder ftp(FtpProtocol ftp) {
            this.ftp = ftp;
            return this;
        }

        public MetricsBuilder prometheus(PrometheusProtocol prometheus) {
            this.prometheus = prometheus;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskDataRef(AtomicReference<CollectRep.MetricsData> subTaskDataRef) {
            this.subTaskDataRef = subTaskDataRef;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskNum(AtomicInteger subTaskNum) {
            this.subTaskNum = subTaskNum;
            return this;
        }

        @JsonIgnore
        public MetricsBuilder subTaskId(Integer subTaskId) {
            this.subTaskId = subTaskId;
            return this;
        }

        public Metrics build() {
            return new Metrics(this.name, this.i18n, this.protocol, this.priority, this.visible, this.fields, this.aliasFields, this.calculates, this.units, this.telnet, this.ssh, this.ftp, this.prometheus, this.subTaskDataRef, this.subTaskNum, this.subTaskId);
        }

        public String toString() {
            return "Metrics.MetricsBuilder(name=" + this.name + ", i18n=" + this.i18n + ", protocol=" + this.protocol + ", priority=" + this.priority + ", visible=" + this.visible + ", fields=" + this.fields + ", aliasFields=" + this.aliasFields + ", calculates=" + this.calculates + ", units=" + this.units + ", telnet=" + this.telnet + ", ssh=" + this.ssh + ", ftp=" + this.ftp + ", prometheus=" + this.prometheus + ", subTaskDataRef=" + this.subTaskDataRef + ", subTaskNum=" + this.subTaskNum + ", subTaskId=" + this.subTaskId + ")";
        }
    }

    public static class Field {
        private String field;
        private Map<String, String> i18n;
        private byte type = 1;
        private boolean instance = false;
        private boolean label = false;
        private String unit;

        public static FieldBuilder builder() {
            return new FieldBuilder();
        }

        public String getField() {
            return this.field;
        }

        public Map<String, String> getI18n() {
            return this.i18n;
        }

        public byte getType() {
            return this.type;
        }

        public boolean isInstance() {
            return this.instance;
        }

        public boolean isLabel() {
            return this.label;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setI18n(Map<String, String> i18n) {
            this.i18n = i18n;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public void setInstance(boolean instance) {
            this.instance = instance;
        }

        public void setLabel(boolean label) {
            this.label = label;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.isInstance() != other.isInstance()) {
                return false;
            }
            if (this.isLabel() != other.isLabel()) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            Map<String, String> this$i18n = this.getI18n();
            Map<String, String> other$i18n = other.getI18n();
            if (this$i18n == null ? other$i18n != null : !((Object)this$i18n).equals(other$i18n)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            result = result * 59 + (this.isInstance() ? 79 : 97);
            result = result * 59 + (this.isLabel() ? 79 : 97);
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            Map<String, String> $i18n = this.getI18n();
            result = result * 59 + ($i18n == null ? 43 : ((Object)$i18n).hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "Metrics.Field(field=" + this.getField() + ", i18n=" + this.getI18n() + ", type=" + this.getType() + ", instance=" + this.isInstance() + ", label=" + this.isLabel() + ", unit=" + this.getUnit() + ")";
        }

        public Field(String field, Map<String, String> i18n, byte type, boolean instance, boolean label, String unit) {
            this.field = field;
            this.i18n = i18n;
            this.type = type;
            this.instance = instance;
            this.label = label;
            this.unit = unit;
        }

        public Field() {
        }

        public static class FieldBuilder {
            private String field;
            private Map<String, String> i18n;
            private byte type;
            private boolean instance;
            private boolean label;
            private String unit;

            FieldBuilder() {
            }

            public FieldBuilder field(String field) {
                this.field = field;
                return this;
            }

            public FieldBuilder i18n(Map<String, String> i18n) {
                this.i18n = i18n;
                return this;
            }

            public FieldBuilder type(byte type) {
                this.type = type;
                return this;
            }

            public FieldBuilder instance(boolean instance) {
                this.instance = instance;
                return this;
            }

            public FieldBuilder label(boolean label) {
                this.label = label;
                return this;
            }

            public FieldBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Field build() {
                return new Field(this.field, this.i18n, this.type, this.instance, this.label, this.unit);
            }

            public String toString() {
                return "Metrics.Field.FieldBuilder(field=" + this.field + ", i18n=" + this.i18n + ", type=" + this.type + ", instance=" + this.instance + ", label=" + this.label + ", unit=" + this.unit + ")";
            }
        }
    }
}

