/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.protocol.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    private static final Pattern PHONE_PATTERN = Pattern.compile("^(((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(19[0-9])|(18[0-9])|(17[0-9]))+\\d{8})?$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-+]?[0-9]*\\.?[0-9]+$");
    private static final int PHONE_LENGTH = 11;

    public static Integer parseStrInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Double parseStrDouble(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return NUMBER_PATTERN.matcher(str).matches();
    }

    public static int parseTimeStrToSecond(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return -1;
        }
        try {
            return LocalTime.parse(str).toSecondOfDay();
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static String parseDoubleStr(String str, String unit) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            if (unit != null && str.endsWith(unit)) {
                str = str.substring(0, str.length() - unit.length());
            }
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean validateEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        Matcher m = EMAIL_PATTERN.matcher(email);
        return m.find();
    }

    public static boolean validatePhoneNum(String phoneNum) {
        if (StringUtils.isBlank((CharSequence)phoneNum) || phoneNum.length() != 11) {
            return false;
        }
        Matcher m = PHONE_PATTERN.matcher(phoneNum);
        return m.find();
    }

    public static String getMessageFromThrowable(Throwable throwable) {
        if (throwable == null) {
            return "throwable is null, unknown error.";
        }
        String message = null;
        Throwable cause = throwable.getCause();
        if (cause != null) {
            message = cause.getMessage();
        }
        if (message == null || "".equals(message)) {
            message = throwable.getMessage();
        }
        if (message == null || "".equals(message)) {
            message = throwable.getLocalizedMessage();
        }
        if (message == null || "".equals(message)) {
            message = throwable.toString();
        }
        if (message == null || "".equals(message)) {
            message = "unknown error.";
        }
        return message;
    }

    public static String removeBlankLine(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("(?m)^\\s*$(\\n|\\r\\n)", "");
    }

    public static String getLangMappingValueFromI18nMap(String lang, Map<String, String> i18nMap) {
        if (i18nMap == null || i18nMap.isEmpty()) {
            return null;
        }
        return Optional.ofNullable(i18nMap.get(lang)).orElse(i18nMap.values().stream().findFirst().orElse(null));
    }
}

