/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.repository.config.env;

import java.io.IOException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePropertySource;

public class MybatisPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String PROPERTY_SOURCE_NAME = "jdbc-mapper";
    public static final String RESOURCE_LOCATION_PATTERN = "classpath*:META-INF/jdbc-mapper.properties";
    private static final String FILE_ENCODING = "UTF-8";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ResourceLoader resourceLoader = this.getResourceLoader(application);
        this.processPropertySource(environment, resourceLoader);
    }

    private ResourceLoader getResourceLoader(SpringApplication application) {
        ResourceLoader resourceLoader = application.getResourceLoader();
        if (resourceLoader == null) {
            resourceLoader = new DefaultResourceLoader(application.getClassLoader());
        }
        return resourceLoader;
    }

    private void processPropertySource(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        try {
            PropertySource multiDataSourceDefaultPropertySource = this.buildPropertySource(resourceLoader);
            MutablePropertySources propertySources = environment.getPropertySources();
            propertySources.addLast(multiDataSourceDefaultPropertySource);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private PropertySource buildPropertySource(ResourceLoader resourceLoader) throws IOException {
        CompositePropertySource propertySource = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        this.appendPropertySource(propertySource, resourceLoader);
        return propertySource;
    }

    private void appendPropertySource(CompositePropertySource propertySource, ResourceLoader resourceLoader) throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(resourceLoader);
        for (Resource resource : resources = resourcePatternResolver.getResources(RESOURCE_LOCATION_PATTERN)) {
            if (!resource.exists()) continue;
            String internalName = String.valueOf(resource.getURL());
            propertySource.addPropertySource((PropertySource)new ResourcePropertySource(internalName, new EncodedResource(resource, FILE_ENCODING)));
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

