/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.repository.persist;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.dc.alarm.api.entity.AlarmEcsInstance;
import com.ovopark.dc.alarm.api.model.ResourceQuery;
import com.ovopark.dc.alarm.repository.dao.AlarmEcsInstanceMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AlarmEcsInstancePersistService
extends ServiceImpl<AlarmEcsInstanceMapper, AlarmEcsInstance> {
    public AlarmEcsInstance getLastEcsInstance() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(AlarmEcsInstance::getId)).last("limit 1");
        AlarmEcsInstance one = (AlarmEcsInstance)this.getOne((Wrapper)queryWrapper);
        return one;
    }

    public void removeAllBeforeLastEcsInstance(Integer id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().le(AlarmEcsInstance::getId, (Object)id);
        this.remove((Wrapper)queryWrapper);
    }

    public void batchInsert(List<AlarmEcsInstance> instances) {
        this.saveBatch(instances);
    }

    public int selectCount(ResourceQuery resourceQuery, List<String> instanceNames) {
        LambdaQueryWrapper alarmEcsInstanceQueryWrapper = new LambdaQueryWrapper();
        alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.in(AlarmEcsInstance::getInstanceName, instanceNames);
        if (StringUtils.isNotBlank((CharSequence)resourceQuery.getPublicIpAddress())) {
            alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.like(AlarmEcsInstance::getPublicIp, (Object)resourceQuery.getPublicIpAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)resourceQuery.getInstanceId())) {
            alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.like(AlarmEcsInstance::getInstanceId, (Object)resourceQuery.getInstanceId());
        }
        if (StringUtils.isNotBlank((CharSequence)resourceQuery.getInstanceName())) {
            alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.like(AlarmEcsInstance::getInstanceName, (Object)resourceQuery.getInstanceName());
        }
        return this.count((Wrapper)alarmEcsInstanceQueryWrapper);
    }

    public Page<AlarmEcsInstance> selectPage(ResourceQuery resourceQuery, Page<AlarmEcsInstance> page, Integer totalCount, List<String> instanceNames) {
        LambdaQueryWrapper alarmEcsInstanceQueryWrapper = new LambdaQueryWrapper();
        alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.in(AlarmEcsInstance::getInstanceName, instanceNames)).orderByDesc(AlarmEcsInstance::getInstanceId);
        if (StringUtils.isNotBlank((CharSequence)resourceQuery.getPublicIpAddress())) {
            alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.like(AlarmEcsInstance::getPublicIp, (Object)resourceQuery.getPublicIpAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)resourceQuery.getInstanceId())) {
            alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.like(AlarmEcsInstance::getInstanceId, (Object)resourceQuery.getInstanceId());
        }
        if (StringUtils.isNotBlank((CharSequence)resourceQuery.getInstanceName())) {
            alarmEcsInstanceQueryWrapper = (LambdaQueryWrapper)alarmEcsInstanceQueryWrapper.like(AlarmEcsInstance::getInstanceName, (Object)resourceQuery.getInstanceName());
        }
        page.setTotal((long)totalCount.intValue());
        page.setCurrent((long)resourceQuery.getPageNumber().intValue());
        page.setSize((long)resourceQuery.getPageSize().intValue());
        return (Page)this.page((IPage)page, (Wrapper)alarmEcsInstanceQueryWrapper);
    }
}

