/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.repository.persist;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckStrategy;
import com.ovopark.dc.alarm.api.enums.StrategyStatusEnum;
import com.ovopark.dc.alarm.api.model.AlarmHealthCheckStrategyWrapper;
import com.ovopark.dc.alarm.api.model.AuthUserInfo;
import com.ovopark.dc.alarm.api.model.HealthCheckQuery;
import com.ovopark.dc.alarm.repository.dao.AlarmHealthCheckStrategyMapper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class AlarmHealthCheckStrategyPersistService
extends ServiceImpl<AlarmHealthCheckStrategyMapper, AlarmHealthCheckStrategy> {
    private final AlarmHealthCheckStrategyMapper mapper;

    public AlarmHealthCheckStrategyPersistService(AlarmHealthCheckStrategyMapper mapper) {
        this.mapper = mapper;
    }

    public List<AlarmHealthCheckStrategyWrapper> listAll() {
        return this.mapper.listAll();
    }

    public AlarmHealthCheckStrategyWrapper getDetailById(Integer id) {
        return this.mapper.getDetailById(id);
    }

    public Integer countByQuery(HealthCheckQuery query) {
        return this.mapper.countByQuery(query);
    }

    public List<AlarmHealthCheckStrategyWrapper> listByQuery(HealthCheckQuery query) {
        return this.mapper.listByQuery(query);
    }

    public void changeStatus(Integer strategyId, Integer status, AuthUserInfo authUserInfo) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(AlarmHealthCheckStrategy::getId, (Object)strategyId)).set(AlarmHealthCheckStrategy::getStatus, (Object)status)).set(AlarmHealthCheckStrategy::getModifyBy, (Object)authUserInfo.getUsername())).set(AlarmHealthCheckStrategy::getModifyTime, (Object)new Date());
        this.update((Wrapper)updateWrapper);
    }

    public Integer countHealthStrategy(boolean isHealth) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AlarmHealthCheckStrategy::getStatus, (Object)StrategyStatusEnum.START.getCode())).eq(AlarmHealthCheckStrategy::isHealth, (Object)isHealth);
        return this.list((Wrapper)queryWrapper).size();
    }

    public AlarmHealthCheckStrategy getByStrategyName(String strategyName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AlarmHealthCheckStrategy::getStrategyName, (Object)strategyName);
        return (AlarmHealthCheckStrategy)this.getOne((Wrapper)queryWrapper);
    }

    public AlarmHealthCheckStrategy getByStrategyName(String strategyName, Integer id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AlarmHealthCheckStrategy::getStrategyName, (Object)strategyName)).ne(AlarmHealthCheckStrategy::getId, (Object)id);
        return (AlarmHealthCheckStrategy)this.getOne((Wrapper)queryWrapper);
    }

    public void updateStrateyHealthCheck(String uniqueNo, Date date, boolean health) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (Objects.isNull(date)) {
            ((LambdaUpdateWrapper)updateWrapper.lambda().eq(AlarmHealthCheckStrategy::getUniqueNo, (Object)uniqueNo)).set(AlarmHealthCheckStrategy::isHealth, (Object)health);
        } else {
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(AlarmHealthCheckStrategy::getUniqueNo, (Object)uniqueNo)).set(AlarmHealthCheckStrategy::getLastUnhealthTime, (Object)date)).set(AlarmHealthCheckStrategy::isHealth, (Object)health);
        }
        this.update((Wrapper)updateWrapper);
    }

    public AlarmHealthCheckStrategy getByUniqueNo(String strategyNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AlarmHealthCheckStrategy::getUniqueNo, (Object)strategyNo);
        return (AlarmHealthCheckStrategy)this.getOne((Wrapper)queryWrapper);
    }
}

