/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.request.okhttp;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.alarm.http.Callback;
import com.ovopark.dc.alarm.http.RequestHttpEntity;
import com.ovopark.dc.alarm.http.request.AsyncHttpClientRequest;
import com.ovopark.dc.alarm.http.request.okhttp.OkHttpClientRequestManager;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpAsyncClientRequest
implements AsyncHttpClientRequest {
    private static OkHttpAsyncClientRequest clientRequest = null;

    public static OkHttpAsyncClientRequest getInstance() {
        return clientRequest;
    }

    @Override
    public <T> void execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity, ResponseHandler<T> responseHandler, Callback<T> callback) throws Exception {
        switch (httpMethod) {
            case "GET": {
                this.get(uri, requestHttpEntity, responseHandler, callback);
                break;
            }
            case "POST": {
                this.post(uri, requestHttpEntity, responseHandler, callback);
                break;
            }
        }
    }

    private <T> void get(URI uri, RequestHttpEntity requestHttpEntity, ResponseHandler<T> responseHandler, Callback<T> callback) {
        Request request = new Request.Builder().url(URLDecoder.decode(uri.toString(), "UTF-8")).headers(OkHttpClientRequestManager.getInstance().generateHeaders(requestHttpEntity.getHeaders())).build();
        OkHttpClientRequestManager.asyncCall(request, callback, responseHandler);
    }

    private <T> void post(URI uri, RequestHttpEntity requestHttpEntity, ResponseHandler<T> responseHandler, Callback<T> callback) {
        MediaType mediaType = MediaType.parse((String)"application/json;charset=UTF-8");
        Request request = new Request.Builder().url(URLDecoder.decode(uri.toString(), "UTF-8")).headers(OkHttpClientRequestManager.getInstance().generateHeaders(requestHttpEntity.getHeaders())).post(RequestBody.create((MediaType)mediaType, (String)JSON.toJSONString((Object)requestHttpEntity.getBody()))).build();
        OkHttpClientRequestManager.asyncCall(request, callback, responseHandler);
    }

    @Override
    public void close() throws IOException {
        clientRequest.close();
    }

    static {
        if (clientRequest == null) {
            clientRequest = new OkHttpAsyncClientRequest();
        }
    }
}

