/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.request.okhttp;

import com.ovopark.dc.alarm.http.Callback;
import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.HttpRestResult;
import com.ovopark.dc.alarm.http.RestResult;
import com.ovopark.dc.alarm.http.response.OkhttpClientHttpResponse;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpClientRequestManager {
    private static OkHttpClient client = null;
    private static OkHttpClientRequestManager instance = null;

    private OkHttpClientRequestManager() {
    }

    public static OkHttpClientRequestManager getInstance() {
        if (instance == null) {
            instance = new OkHttpClientRequestManager();
        }
        return instance;
    }

    public static OkHttpClient getRequestClient() {
        if (client == null) {
            client = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).addInterceptor(chain -> {
                Request.Builder builder = chain.request().newBuilder().addHeader("Connection", "close");
                return chain.proceed(builder.build());
            }).build();
        }
        return client;
    }

    protected static void asyncCall(Request request, final Callback callback, final ResponseHandler responseHandler) {
        Call call = OkHttpClientRequestManager.getRequestClient().newCall(request);
        call.enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onError(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                OkhttpClientHttpResponse okhttpResponse = new OkhttpClientHttpResponse(response);
                HttpRestResult httpRestResult = responseHandler.handle(okhttpResponse);
                RestResult restResult = RestResult.builder().withCode(httpRestResult.getCode()).withData(httpRestResult.getData()).withMsg(httpRestResult.getMessage()).build();
                callback.onReceive(restResult);
            }
        });
    }

    protected static Response syncCall(Request request, Callback callback) {
        Call call = OkHttpClientRequestManager.getRequestClient().newCall(request);
        return call.execute();
    }

    public Headers generateHeaders(Header header) {
        Headers.Builder hdb = new Headers.Builder();
        header.getHeader().entrySet().forEach(hd -> hdb.add((String)hd.getKey(), (String)hd.getValue()));
        return hdb.build();
    }
}

