/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.request.okhttp;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.alarm.http.Callback;
import com.ovopark.dc.alarm.http.RequestHttpEntity;
import com.ovopark.dc.alarm.http.RestResult;
import com.ovopark.dc.alarm.http.request.SyncHttpClientRequest;
import com.ovopark.dc.alarm.http.request.okhttp.OkHttpClientRequestManager;
import com.ovopark.dc.alarm.http.response.OkhttpClientHttpResponse;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpSyncClientRequest
implements SyncHttpClientRequest {
    private static OkHttpSyncClientRequest clientRequest = null;

    public static OkHttpSyncClientRequest getInstance() {
        if (clientRequest == null) {
            clientRequest = new OkHttpSyncClientRequest();
        }
        return clientRequest;
    }

    @Override
    public <T> RestResult execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity, ResponseHandler<T> responseHandler, Callback<T> callback) throws Exception {
        switch (httpMethod) {
            case "GET": {
                return this.get(uri, requestHttpEntity, responseHandler, callback);
            }
            case "POST": {
                return this.post(uri, requestHttpEntity, responseHandler, callback);
            }
        }
        return null;
    }

    private <T> RestResult<T> get(URI uri, RequestHttpEntity requestHttpEntity, ResponseHandler<T> responseHandler, Callback<T> callback) {
        Request request = new Request.Builder().url(URLDecoder.decode(uri.toString(), "UTF-8")).headers(OkHttpClientRequestManager.getInstance().generateHeaders(requestHttpEntity.getHeaders())).build();
        Response response = OkHttpClientRequestManager.syncCall(request, callback);
        OkhttpClientHttpResponse clientResponse = new OkhttpClientHttpResponse(response);
        return responseHandler.handle(clientResponse);
    }

    private <T> RestResult post(URI uri, RequestHttpEntity requestHttpEntity, ResponseHandler<T> responseHandler, Callback<T> callback) {
        MediaType mediaType = MediaType.parse((String)"application/json;charset=UTF-8");
        Request request = new Request.Builder().url(URLDecoder.decode(uri.toString(), "UTF-8")).headers(OkHttpClientRequestManager.getInstance().generateHeaders(requestHttpEntity.getHeaders())).post(RequestBody.create((MediaType)mediaType, (String)JSON.toJSONString((Object)requestHttpEntity.getBody()))).build();
        Response response = OkHttpClientRequestManager.syncCall(request, callback);
        OkhttpClientHttpResponse clientResponse = new OkhttpClientHttpResponse(response);
        return responseHandler.handle(clientResponse);
    }

    @Override
    public void close() throws IOException {
    }
}

