/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.template;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.dc.alarm.http.response.BeanResponseHandler;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import com.ovopark.dc.alarm.http.response.StringResponseHandler;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class BaseRestTemplate {
    static ObjectMapper mapper = new ObjectMapper();
    private final Map<String, ResponseHandler> responseHandlerMap = new HashMap<String, ResponseHandler>();

    public BaseRestTemplate() {
        this.initDefaultResponseHandler();
    }

    private void initDefaultResponseHandler() {
        this.responseHandlerMap.put("default_bean_handler", new BeanResponseHandler());
        this.responseHandlerMap.put("java.lang.String", new StringResponseHandler());
    }

    public void registerResponseHandler(String responseHandlerType, ResponseHandler responseHandler) {
        this.responseHandlerMap.put(responseHandlerType, responseHandler);
    }

    protected ResponseHandler selectResponseHandler(Type responseType) {
        ResponseHandler responseHandler = null;
        if (responseType == null) {
            responseHandler = this.responseHandlerMap.get("java.lang.String");
        }
        if (responseHandler == null) {
            JavaType javaType = mapper.constructType(responseType);
            String name = javaType.getRawClass().getName();
            responseHandler = this.responseHandlerMap.get(name);
        }
        if (responseHandler == null) {
            responseHandler = this.responseHandlerMap.get("default_bean_handler");
        }
        responseHandler.setResponseType(responseType);
        return responseHandler;
    }
}

