/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.response;

import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.HttpRestResult;
import com.ovopark.dc.alarm.http.response.HttpClientResponse;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import com.ovopark.dc.alarm.http.utils.IoUtils;
import java.lang.reflect.Type;

public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    private Type responseType;

    @Override
    public final void setResponseType(Type responseType) {
        this.responseType = responseType;
    }

    @Override
    public final HttpRestResult<T> handle(HttpClientResponse response) throws Exception {
        if (200 != response.getStatusCode()) {
            return this.handleError(response);
        }
        return this.convertResult(response, this.responseType);
    }

    private HttpRestResult<T> handleError(HttpClientResponse response) throws Exception {
        Header headers = response.getHeaders();
        String message = IoUtils.toString(response.getBody(), headers.getCharset());
        return new HttpRestResult<Object>(headers, response.getStatusCode(), null, message);
    }

    public abstract HttpRestResult<T> convertResult(HttpClientResponse var1, Type var2) throws Exception;
}

