/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.template;

import com.ovopark.dc.alarm.http.Callback;
import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.Query;
import com.ovopark.dc.alarm.http.RequestHttpEntity;
import com.ovopark.dc.alarm.http.request.AsyncHttpClientRequest;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import com.ovopark.dc.alarm.http.template.BaseRestTemplate;
import com.ovopark.dc.alarm.http.utils.HttpUtils;
import java.lang.reflect.Type;
import java.net.URI;
import org.springframework.http.HttpMethod;

public class AsyncRestTemplate
extends BaseRestTemplate {
    private final AsyncHttpClientRequest clientRequest;

    public AsyncRestTemplate(AsyncHttpClientRequest clientRequest) {
        this.clientRequest = clientRequest;
    }

    public <T> void get(String url, Header header, Query query, Type responseType, Callback<T> callback) {
        this.execute(url, HttpMethod.GET.name(), new RequestHttpEntity(header, query), responseType, callback);
    }

    public <T> void post(String url, Header header, Query query, Object body, Type responseType, Callback<T> callback) {
        this.execute(url, HttpMethod.POST.name(), new RequestHttpEntity(header, query, body), responseType, callback);
    }

    private <T> void execute(String url, String httpMethod, RequestHttpEntity requestEntity, Type type, Callback<T> callback) {
        try {
            URI uri = HttpUtils.buildUri(url, requestEntity.getQuery());
            ResponseHandler responseHandler = super.selectResponseHandler(type);
            this.clientRequest.execute(uri, httpMethod, requestEntity, responseHandler, callback);
        }
        catch (Exception e) {
            callback.onError(e);
        }
    }
}

