/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.template;

import com.ovopark.dc.alarm.http.Callback;
import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.Query;
import com.ovopark.dc.alarm.http.RequestHttpEntity;
import com.ovopark.dc.alarm.http.RestResult;
import com.ovopark.dc.alarm.http.request.SyncHttpClientRequest;
import com.ovopark.dc.alarm.http.response.ResponseHandler;
import com.ovopark.dc.alarm.http.template.BaseRestTemplate;
import com.ovopark.dc.alarm.http.utils.HttpUtils;
import java.lang.reflect.Type;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

public class SyncRestTemplate
extends BaseRestTemplate {
    private final SyncHttpClientRequest clientRequest;

    public SyncRestTemplate(SyncHttpClientRequest clientRequest) {
        this.clientRequest = clientRequest;
    }

    public <T> RestResult get(String url, Header header, Query query, Type responseType) {
        return this.execute(url, HttpMethod.GET.name(), new RequestHttpEntity(header, query), responseType, new SyncCallBack());
    }

    public <T> RestResult post(String url, Header header, Query query, Object body, Type responseType) {
        return this.execute(url, HttpMethod.POST.name(), new RequestHttpEntity(header, query, body), responseType, new SyncCallBack());
    }

    private <T> RestResult execute(String url, String httpMethod, RequestHttpEntity requestEntity, Type type, @NonNull Callback<T> callback) {
        try {
            URI uri = HttpUtils.buildUri(url, requestEntity.getQuery());
            ResponseHandler responseHandler = super.selectResponseHandler(type);
            return this.clientRequest.execute(uri, httpMethod, requestEntity, responseHandler, callback);
        }
        catch (Exception e) {
            callback.onError(e);
            return RestResult.builder().withCode(HttpStatus.INTERNAL_SERVER_ERROR.value()).withMsg("[SyncRestTemplate.execute] failed to execute request ,error: " + e.getMessage()).build();
        }
    }

    private class SyncCallBack
    implements Callback {
        private SyncCallBack() {
        }

        public void onReceive(RestResult result) {
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onCancel() {
        }
    }
}

