/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.http.utils;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.alarm.http.Header;
import com.ovopark.dc.alarm.http.Query;
import com.ovopark.dc.alarm.http.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.http.MediaType;

public final class HttpUtils {
    private static final Pattern CONTEXT_PATH_MATCH = Pattern.compile("(\\/)\\1+");

    public static void initRequestHeader(HttpRequestBase requestBase, Header header) {
        Iterator<Map.Entry<String, String>> iterator = header.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            requestBase.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void initRequestEntity(HttpRequestBase requestBase, Object body, Header header) throws Exception {
        if (body == null) {
            return;
        }
        if (requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)requestBase;
            MediaType mediaType = MediaType.valueOf((String)header.getValue("Content-Type"));
            ContentType contentType = ContentType.create((String)mediaType.getType(), (Charset)mediaType.getCharset());
            Object entity = body instanceof byte[] ? new ByteArrayEntity((byte[])body, contentType) : new StringEntity(body instanceof String ? (String)body : JSON.toJSONString((Object)body), contentType);
            request.setEntity((HttpEntity)entity);
        }
    }

    public static void initRequestFromEntity(HttpRequestBase requestBase, Map<String, String> body, String charset) throws Exception {
        if (body == null || body.isEmpty()) {
            return;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(body.size());
        for (Map.Entry<String, String> entry : body.entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        if (requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)requestBase;
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, charset);
            request.setEntity((HttpEntity)entity);
        }
    }

    public static String buildUrl(boolean isHttps, String serverAddr, String ... subPaths) {
        StringBuilder sb = new StringBuilder();
        if (isHttps) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(serverAddr);
        String pre = null;
        for (String subPath : subPaths) {
            if (StringUtils.isBlank(subPath)) continue;
            Matcher matcher = CONTEXT_PATH_MATCH.matcher(subPath);
            if (matcher.find()) {
                throw new IllegalArgumentException("Illegal url path expression : " + subPath);
            }
            if (pre == null || !pre.endsWith("/")) {
                if (subPath.startsWith("/")) {
                    sb.append(subPath);
                } else {
                    sb.append("/").append(subPath);
                }
            } else if (subPath.startsWith("/")) {
                sb.append(subPath.replaceFirst("\\/", ""));
            } else {
                sb.append(subPath);
            }
            pre = subPath;
        }
        return sb.toString();
    }

    public static Map<String, String> translateParameterMap(Map<String, String[]> parameterMap) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String key : parameterMap.keySet()) {
            map.put(key, parameterMap.get(key)[0]);
        }
        return map;
    }

    public static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == params || params.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) continue;
            sb.append(entry.getKey()).append("=");
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append("&");
        }
        return sb.toString();
    }

    public static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static String decode(String str, String encode) throws UnsupportedEncodingException {
        return HttpUtils.innerDecode(null, str, encode);
    }

    public static URI buildUri(String url, Query query) throws URISyntaxException, UnsupportedEncodingException {
        if (query != null && !query.isEmpty()) {
            url = (String)url + "?" + query.toQueryUrl();
        }
        return new URI((String)url);
    }

    public static boolean isTimeoutException(Throwable throwable) {
        return throwable instanceof SocketTimeoutException || throwable instanceof ConnectTimeoutException || throwable instanceof TimeoutException || throwable.getCause() instanceof TimeoutException;
    }

    private static String innerDecode(String pre, String now, String encode) throws UnsupportedEncodingException {
        if (org.apache.commons.codec.binary.StringUtils.equals((CharSequence)pre, (CharSequence)now)) {
            return pre;
        }
        pre = now;
        now = URLDecoder.decode(now, encode);
        return HttpUtils.innerDecode(pre, now, encode);
    }
}

