/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.model;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EsQueryWrapper {
    private final StringBuilder queryStr = new StringBuilder();

    private EsQueryWrapper() {
    }

    public static EsQueryWrapper must() {
        EsQueryWrapper wrapper = new EsQueryWrapper();
        wrapper.queryStr.append("{\"bool\":{\"must\":[");
        return wrapper;
    }

    public static EsQueryWrapper should() {
        EsQueryWrapper wrapper = new EsQueryWrapper();
        wrapper.queryStr.append("{\"bool\":{\"should\":[");
        return wrapper;
    }

    public EsQueryWrapper matchPhrase(String field, Object value) {
        if (!StringUtils.isEmpty((CharSequence)field) && !this.isEmptyStr(value)) {
            this.queryStr.append("{\"match_phrase\":{\"").append(field).append("\":{\"query\":\"").append(value).append("\"}}},");
        }
        return this;
    }

    public EsQueryWrapper exists(String field) {
        if (!StringUtils.isEmpty((CharSequence)field)) {
            this.queryStr.append("{\"exists\":{\"field\":\"").append(field).append("\"}},");
        }
        return this;
    }

    public EsQueryWrapper queryString(String field, Object value) {
        if (!StringUtils.isEmpty((CharSequence)field) && !this.isEmptyStr(value)) {
            this.queryStr.append("{\"query_string\":{\"query\":\"").append(value).append("\",\"default_field\":\"").append(field).append("\"}},");
        }
        return this;
    }

    public EsQueryWrapper range(String field, Number leftLimit, Number rightLimit) {
        if (!(StringUtils.isEmpty((CharSequence)field) || this.isEmptyStr(rightLimit) || this.isEmptyStr(leftLimit))) {
            this.queryStr.append("{\"range\":{\"").append(field).append("\":{\"gte\":").append(leftLimit).append(",\"lt\":").append(rightLimit).append("}}},");
        }
        return this;
    }

    public EsQueryWrapper in(String field, List<?> values) {
        if (!CollectionUtils.isEmpty(values)) {
            if (values.size() == 1) {
                this.matchPhrase(field, values.get(0));
                return this;
            }
            EsQueryWrapper wrapper = EsQueryWrapper.should();
            for (Object item : values) {
                wrapper.matchPhrase(field, item);
            }
            this.queryStr.append(wrapper.end()).append(",");
        }
        return this;
    }

    public String end() {
        int last = this.queryStr.length() - 1;
        char cLast = this.queryStr.charAt(last);
        if (cLast == ',') {
            this.queryStr.setCharAt(last, ']');
        } else if (cLast != ']') {
            this.queryStr.append(']');
        }
        return this.queryStr.append("}}").toString();
    }

    private boolean isEmptyStr(Object str) {
        return Objects.isNull(str) || "".equals(str);
    }
}

