/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.model.request;

import cn.hutool.core.util.BooleanUtil;
import com.ovopark.dc.log.model.EsQueryWrapper;
import com.ovopark.dc.log.model.request.BasePage;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class QueryRequest
implements BasePage,
Serializable {
    private String id;
    private Integer limit = 30;
    private Long page = 0L;
    private List<String> appName;
    private Long dtTimeFrom;
    private Long dtTimeTo;
    private List<String> serverIp;
    private String logLevel;
    private String content;
    private String traceId;
    private String source;
    private Boolean onlyWithTraceId;

    public String queryStr() {
        this.logLevel = this.logLevel == null ? null : this.logLevel.toUpperCase(Locale.ROOT);
        EsQueryWrapper wrapper = EsQueryWrapper.must().queryString("content", this.content).range("dtTime", this.dtTimeFrom, this.dtTimeTo).in("appName", this.appName).matchPhrase("source", this.source).matchPhrase("traceId", this.traceId).matchPhrase("logLevel", this.logLevel).in("serverIp", this.serverIp);
        if (BooleanUtil.isTrue((Boolean)this.onlyWithTraceId)) {
            wrapper.exists("traceId");
        }
        return "{\"query\":" + wrapper.end() + ",\"sort\":[{\"dtTime\":{\"order\":\"desc\"}}],\"aggregations\":{\"2\":{\"date_histogram\":{\"field\":\"dtTime\",\"interval\":30000,\"min_doc_count\":0}}}}";
    }

    public void setOnlyWithTraceId(Boolean onlyWithTraceId) {
        this.onlyWithTraceId = onlyWithTraceId;
    }

    public Boolean getOnlyWithTraceId() {
        return this.onlyWithTraceId;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public List<String> getAppName() {
        return this.appName;
    }

    public void setAppName(List<String> appName) {
        this.appName = appName;
    }

    public List<String> getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(List<String> serverIp) {
        this.serverIp = serverIp;
    }

    public boolean correctTimeRange() {
        if (this.dtTimeFrom == null || this.dtTimeTo == null) {
            return false;
        }
        return this.dtTimeFrom <= this.dtTimeTo;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setDtTimeFrom(Long dtTimeFrom) {
        this.dtTimeFrom = dtTimeFrom;
    }

    public void setDtTimeTo(Long dtTimeTo) {
        this.dtTimeTo = dtTimeTo;
    }

    public String getContent() {
        return this.content;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public Long getDtTimeFrom() {
        return this.dtTimeFrom;
    }

    public Long getDtTimeTo() {
        return this.dtTimeTo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public void setPage(Long page) {
        this.page = page;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Long getPage() {
        return this.page;
    }
}

