/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.logging.log4j;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.constant.LogMessageConstant;
import com.ovopark.dc.log.core.AbstractClient;
import com.ovopark.dc.log.core.factory.MessageAppenderFactory;
import com.ovopark.dc.log.core.kafka.KafkaProducerClient;
import com.ovopark.dc.log.core.util.ThreadPoolUtil;
import com.ovopark.dc.log.logging.log4j.Log4jLogUtil;
import com.ovopark.dc.log.model.BaseLog;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jKafkaAppender
extends AppenderSkeleton {
    private KafkaProducerClient kafkaClient;
    private String appName;
    private String kafkaHosts;
    private String runModel;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;
    private boolean compressor = false;
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setKafkaHosts(String kafkaHosts) {
        this.kafkaHosts = kafkaHosts;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public void setKafkaClient(KafkaProducerClient kafkaClient) {
        this.kafkaClient = kafkaClient;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    protected void append(LoggingEvent loggingEvent) {
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.kafkaClient == null) {
            this.kafkaClient = KafkaProducerClient.getInstance((String)this.kafkaHosts, (String[])new String[]{this.compressor ? "lz4" : "none"});
            MessageAppenderFactory.initQueue((int)this.logQueueSize);
            for (int a = 0; a < this.threadPoolSize; ++a) {
                threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
            }
        }
        BaseLog logMessage = Log4jLogUtil.getLogMessage(this.appName, loggingEvent);
        MessageAppenderFactory.pushRunDataQueue((String)JSON.toJSONString((Object)logMessage));
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

