/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.logging.log4j;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.dc.log.core.factory.LogFactory;
import com.ovopark.dc.log.core.util.LogExceptionStackTrace;
import com.ovopark.dc.log.model.AutoPushLogMessage;
import com.ovopark.dc.log.model.BaseLog;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Log4jLogUtil {
    public static final String DELIM_STR = "{}";

    public static BaseLog getLogMessage(String appName, LoggingEvent loggingEvent) {
        String formattedMessage = Log4jLogUtil.getMessage(loggingEvent);
        Level logLevel = loggingEvent.getLevel();
        AutoPushLogMessage autoPushLog = LogFactory.getAutoPushLog((String)appName, (String)formattedMessage, (long)loggingEvent.getTimeStamp());
        if (!autoPushLog.hasLoadedExceptionInfo()) {
            autoPushLog.setClassName(loggingEvent.getLoggerName());
            LocationInfo locationInfo = loggingEvent.getLocationInformation();
            String method = locationInfo.getMethodName();
            String line = locationInfo.getLineNumber();
            autoPushLog.setMethod(method + "(" + locationInfo.getFileName() + ":" + line + ")");
        }
        autoPushLog.setDateTime(DateUtil.date((long)loggingEvent.getTimeStamp()).toString());
        autoPushLog.setLogLevel(logLevel.toString());
        return Log4jLogUtil.pourMDCInfo(autoPushLog, loggingEvent);
    }

    private static AutoPushLogMessage pourMDCInfo(AutoPushLogMessage autoPushLog, LoggingEvent logEvent) {
        Map mdc = logEvent.getProperties();
        if (!CollectionUtils.isEmpty((Map)mdc)) {
            autoPushLog.putExtraData(mdc);
        }
        return autoPushLog;
    }

    private static String getMessage(LoggingEvent logEvent) {
        if (logEvent.getLevel().toInt() == 40000) {
            String msg = "";
            if (logEvent.getThrowableInformation() != null) {
                msg = LogExceptionStackTrace.errorStackTrace((Object)logEvent.getThrowableInformation().getThrowable()).toString();
            }
            if (logEvent.getRenderedMessage() != null && logEvent.getRenderedMessage().contains(DELIM_STR)) {
                FormattingTuple format = MessageFormatter.format((String)logEvent.getRenderedMessage(), (Object)msg);
                return format.getMessage();
            }
            return logEvent.getRenderedMessage() + "\n" + msg;
        }
        return logEvent.getRenderedMessage();
    }
}

