/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.logging.log4j2;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.constant.LogMessageConstant;
import com.ovopark.dc.log.core.AbstractClient;
import com.ovopark.dc.log.core.factory.MessageAppenderFactory;
import com.ovopark.dc.log.core.kafka.KafkaProducerClient;
import com.ovopark.dc.log.core.util.ThreadPoolUtil;
import com.ovopark.dc.log.logging.log4j2.Log4j2LogUtil;
import com.ovopark.dc.log.model.AutoPushLogMessage;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Log4j2KafkaAppender", category="Core", elementType="appender", printObject=true)
public class Log4j2KafkaAppender
extends AbstractAppender {
    private static final ThreadPoolExecutor THREAD_POOL = ThreadPoolUtil.getPool();
    private static KafkaProducerClient kafkaClient;
    private String appName;
    private String kafkaHosts;
    private String runModel;
    private String expand;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;

    protected Log4j2KafkaAppender(String name, String appName, String kafkaHosts, String runModel, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String expand, int maxCount, int logQueueSize, int threadPoolSize) {
        super(name, filter, layout, ignoreExceptions);
        this.appName = appName;
        this.kafkaHosts = kafkaHosts;
        this.runModel = runModel;
        this.expand = expand;
        this.maxCount = maxCount;
        this.logQueueSize = logQueueSize;
        this.threadPoolSize = threadPoolSize;
    }

    public void append(LogEvent logEvent) {
        AutoPushLogMessage logMessage = Log4j2LogUtil.getLogMessage(this.appName, logEvent);
        MessageAppenderFactory.pushRunDataQueue((String)JSON.toJSONString((Object)logMessage));
    }

    @PluginFactory
    public static Log4j2KafkaAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="kafkaHosts") String kafkaHosts, @PluginAttribute(value="expand") String expand, @PluginAttribute(value="runModel") String runModel, @PluginAttribute(value="maxCount") int maxCount, @PluginAttribute(value="logQueueSize") int logQueueSize, @PluginAttribute(value="threadPoolSize") int threadPoolSize, @PluginAttribute(value="compressor") boolean compressor, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(runModel);
        }
        if (kafkaClient == null) {
            kafkaClient = KafkaProducerClient.getInstance((String)kafkaHosts, (String[])new String[]{compressor ? "lz4" : "none"});
        }
        if (maxCount == 0) {
            maxCount = 100;
        }
        if (logQueueSize == 0) {
            logQueueSize = 10000;
        }
        if (threadPoolSize == 0) {
            threadPoolSize = 1;
        }
        int count = maxCount;
        MessageAppenderFactory.initQueue((int)logQueueSize);
        for (int a = 0; a < threadPoolSize; ++a) {
            THREAD_POOL.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)kafkaClient, (int)count));
        }
        return new Log4j2KafkaAppender(name, appName, kafkaHosts, runModel, filter, layout, true, expand, maxCount, logQueueSize, threadPoolSize);
    }
}

