/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.logging.log4j2;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.dc.log.core.factory.LogFactory;
import com.ovopark.dc.log.core.util.LogExceptionStackTrace;
import com.ovopark.dc.log.model.AutoPushLogMessage;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;

public class Log4j2LogUtil {
    public static final String DELIM_STR = "{}";

    public static AutoPushLogMessage getLogMessage(String appName, LogEvent logEvent) {
        Level logLevel = logEvent.getLevel();
        String formattedMessage = Log4j2LogUtil.getMessage(logEvent);
        AutoPushLogMessage autoPushLog = LogFactory.getAutoPushLog((String)appName, (String)formattedMessage, (long)logEvent.getTimeMillis());
        if (!autoPushLog.hasLoadedExceptionInfo()) {
            autoPushLog.setClassName(logEvent.getLoggerName());
            StackTraceElement stackTraceElement = logEvent.getSource();
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            autoPushLog.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        }
        autoPushLog.setDateTime(DateUtil.date((long)logEvent.getTimeMillis()).toString());
        autoPushLog.setLogLevel(logLevel.toString());
        return Log4j2LogUtil.pourMDCInfo(autoPushLog, logEvent);
    }

    private static AutoPushLogMessage pourMDCInfo(AutoPushLogMessage autoPushLog, LogEvent logEvent) {
        Map mdc = logEvent.getContextData().toMap();
        if (!CollectionUtils.isEmpty((Map)mdc)) {
            autoPushLog.putExtraData(mdc);
        }
        return autoPushLog;
    }

    private static String getMessage(LogEvent logEvent) {
        if (logEvent.getLevel().equals((Object)Level.ERROR)) {
            Throwable thrown = logEvent.getThrown();
            String formatMessage = logEvent.getMessage().getFormat();
            Object[] args = logEvent.getMessage().getParameters();
            if (args != null) {
                int l = args.length;
                for (int i = 0; i < l; ++i) {
                    if (i == l - 1 && args[i] == thrown || !(args[i] instanceof Throwable)) continue;
                    args[i] = LogExceptionStackTrace.errorStackTrace((Object)args[i]);
                }
                formatMessage = Log4j2LogUtil.packageMessage(formatMessage, args);
            }
            if (thrown != null) {
                return Log4j2LogUtil.packageMessage(formatMessage, new String[]{LogExceptionStackTrace.errorStackTrace((Object)thrown).toString()});
            }
            return formatMessage;
        }
        return logEvent.getMessage().getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.contains(DELIM_STR)) {
            return ParameterizedMessageFactory.INSTANCE.newMessage(message, args).getFormattedMessage();
        }
        return LogFactory.packageMessage((String)message, (Object[])args);
    }
}

