/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.constant.LogMessageConstant;
import com.ovopark.dc.log.core.AbstractClient;
import com.ovopark.dc.log.core.factory.MessageAppenderFactory;
import com.ovopark.dc.log.core.kafka.KafkaProducerClient;
import com.ovopark.dc.log.core.util.ThreadPoolUtil;
import com.ovopark.dc.log.logging.logback.LogBackLogUtil;
import com.ovopark.dc.log.model.AutoPushLogMessage;
import java.util.concurrent.ThreadPoolExecutor;

public class LogBackKafkaAppender
extends AppenderBase<ILoggingEvent> {
    private static final ThreadPoolExecutor THREAD_POOL = ThreadPoolUtil.getPool();
    private KafkaProducerClient kafkaClient;
    private String appName;
    private String kafkaHosts;
    private String runModel;
    private String expand;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;
    private boolean compressor = false;

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setKafkaHosts(String kafkaHosts) {
        this.kafkaHosts = kafkaHosts;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    protected void append(ILoggingEvent event) {
        AutoPushLogMessage logMessage = LogBackLogUtil.getLogMessage(this.appName, event);
        MessageAppenderFactory.pushRunDataQueue((String)JSON.toJSONString((Object)logMessage));
    }

    public void start() {
        super.start();
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.kafkaClient == null) {
            this.kafkaClient = KafkaProducerClient.getInstance((String)this.kafkaHosts, (String[])new String[]{this.compressor ? "lz4" : "none"});
        }
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (int a = 0; a < this.threadPoolSize; ++a) {
            THREAD_POOL.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
        }
    }
}

