/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.dc.log.core.factory.LogFactory;
import com.ovopark.dc.log.core.util.LogExceptionStackTrace;
import com.ovopark.dc.log.model.AutoPushLogMessage;
import java.util.Map;
import org.slf4j.helpers.MessageFormatter;

public class LogBackLogUtil {
    private static final String DELIM_STR = "{}";

    public static AutoPushLogMessage getLogMessage(String appName, ILoggingEvent iLoggingEvent) {
        String formattedMessage = LogBackLogUtil.getMessage(iLoggingEvent);
        Level logLevel = iLoggingEvent.getLevel();
        AutoPushLogMessage autoPushLog = LogFactory.getAutoPushLog((String)appName, (String)formattedMessage, (long)iLoggingEvent.getTimeStamp());
        if (!autoPushLog.hasLoadedExceptionInfo()) {
            autoPushLog.setClassName(iLoggingEvent.getLoggerName());
            StackTraceElement stackTraceElement = iLoggingEvent.getCallerData()[0];
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            autoPushLog.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        }
        autoPushLog.setLogLevel(logLevel.toString());
        return LogBackLogUtil.pourMDCInfo(autoPushLog, iLoggingEvent);
    }

    private static AutoPushLogMessage pourMDCInfo(AutoPushLogMessage autoPushLog, ILoggingEvent iLoggingEvent) {
        Map mdc = iLoggingEvent.getMDCPropertyMap();
        if (!CollectionUtils.isEmpty((Map)mdc)) {
            autoPushLog.putExtraData(mdc);
        }
        return autoPushLog;
    }

    private static String getMessage(ILoggingEvent logEvent) {
        if (Level.ERROR.equals(logEvent.getLevel())) {
            if (logEvent.getThrowableProxy() != null) {
                ThrowableProxy throwableProxy = (ThrowableProxy)logEvent.getThrowableProxy();
                Object[] args = new String[]{LogExceptionStackTrace.errorStackTrace((Object)throwableProxy.getThrowable()).toString()};
                return LogBackLogUtil.packageMessage(logEvent.getMessage(), args);
            }
            Object[] args = logEvent.getArgumentArray();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof Throwable)) continue;
                    args[i] = LogExceptionStackTrace.errorStackTrace((Object)args[i]);
                }
                return LogBackLogUtil.packageMessage(logEvent.getMessage(), args);
            }
        }
        return logEvent.getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.contains(DELIM_STR)) {
            return MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        }
        return LogFactory.packageMessage((String)message, (Object[])args);
    }
}

