/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.aop;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.core.cache.LogContext;
import com.ovopark.dc.log.webroot.util.RequestUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class LogArgsAspect {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.Mapping) || @annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) ||@annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public void argsPointcut() {
    }

    @Before(value="argsPointcut()")
    public void beforeController(JoinPoint joinPoint) {
        Object[] argValues = joinPoint.getArgs();
        String[] argNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        if (argNames == null || argValues == null) {
            return;
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>(argNames.length);
        for (int i = 0; i < argNames.length; ++i) {
            Object argValue = argValues[i];
            if (argValue instanceof HttpServletRequest) {
                Map parameterMap = ((HttpServletRequest)argValue).getParameterMap();
                argMap.putAll(RequestUtil.convertQueryArgsMap(parameterMap));
                continue;
            }
            if (argValue instanceof HttpServletResponse || argValue instanceof MultipartFile) continue;
            argMap.put(argNames[i], argValue);
        }
        try {
            if (!CollectionUtil.isEmpty(argMap)) {
                LogContext.setArgs((String)JSON.toJSONString(argMap));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

