/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.aop;

import com.ovopark.dc.log.core.cache.LogContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LogExceptionAspect {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.ExceptionHandler)")
    public void exceptionPointcut() {
    }

    @Before(value="exceptionPointcut()")
    public void beforeException(JoinPoint joinPoint) {
        Object[] args;
        for (Object arg : args = joinPoint.getArgs()) {
            if (!(arg instanceof Exception)) continue;
            Exception ex = (Exception)arg;
            StackTraceElement stackTraceElement = ex.getStackTrace()[0];
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            String clazz = stackTraceElement.getClassName();
            method = method + "(" + stackTraceElement.getFileName() + ":" + line + ")";
            LogContext.setExceptionClass((String)clazz);
            LogContext.setExceptionMethod((String)method);
            break;
        }
    }
}

