/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.interceptor;

import com.ovopark.dc.log.core.cache.LogContext;
import com.ovopark.dc.log.core.cache.SpanIdGenerator;
import com.ovopark.dc.log.core.util.LocalhostUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class LogHttpClientInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) {
        Args.notNull((Object)request, (String)"HTTP request");
        String traceId = LogContext.getTraceId();
        String args = LogContext.getArgs();
        String ipAddress = LocalhostUtil.getHostIp();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            request.addHeader("dcLogTraceId", traceId);
            request.addHeader("dcLogSpanId", SpanIdGenerator.generateNextSpanId());
            request.addHeader("requestArgs", args);
            request.addHeader("ipAddress", ipAddress);
        } else {
            System.err.println("\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

