/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.interceptor;

import com.ovopark.dc.log.core.cache.LogContext;
import com.ovopark.dc.log.core.cache.SpanIdGenerator;
import com.ovopark.dc.log.core.util.LocalhostUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class LogOkHttpInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        String traceId = LogContext.getTraceId();
        String ipAddress = LocalhostUtil.getHostIp();
        String args = LogContext.getArgs();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            builder.header("dcLogTraceId", traceId);
            builder.header("dcLogSpanId", SpanIdGenerator.generateNextSpanId());
            builder.header("requestArgs", args);
            builder.header("ipAddress", ipAddress);
        } else {
            System.err.println("\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
        return chain.proceed(builder.build());
    }
}

