/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.interceptor;

import com.ovopark.dc.log.core.cache.LogContext;
import com.ovopark.dc.log.core.rpc.LogRpcHandler;
import com.ovopark.dc.log.model.ExternalConfig;
import com.ovopark.dc.log.model.TraceChain;
import com.ovopark.dc.log.webroot.interceptor.AbsLogWebHandlerMethodInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class LogWebInterceptor
extends AbsLogWebHandlerMethodInterceptor {
    @Override
    public boolean preHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (ExternalConfig.logWebInterceptorOn) {
            try {
                String traceId = request.getHeader("dcLogTraceId");
                String spanId = request.getHeader("dcLogSpanId");
                String args = request.getHeader("requestArgs");
                TraceChain traceChain = new TraceChain().setArgs(args).setTraceId(traceId).setSpanId(spanId);
                LogRpcHandler.processProviderSide((TraceChain)traceChain);
                response.addHeader("dcLogTraceId", traceId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void postHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    @Override
    public void afterCompletionByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LogContext.removeAllThreadLocal();
    }
}

