/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.request;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class RecycleRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] requestBody = null;

    public RecycleRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            this.requestBody = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream recycleByte = new ByteArrayInputStream(this.requestBody);
        return new ServletInputStream(){

            public int read() {
                return recycleByte.read();
            }

            public boolean isFinished() {
                return recycleByte.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }
}

