/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.webroot.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class RequestUtil {
    private static final String CONTENT_TYPE = "application/json";

    public static String getArgsByRequest(HttpServletRequest request) {
        Map map;
        StringBuilder argsBuilder = new StringBuilder(128);
        if (Objects.equals(CONTENT_TYPE, request.getContentType())) {
            String postArgs = null;
            try {
                postArgs = StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (StringUtils.hasLength(postArgs)) {
                argsBuilder.append("postJson: ").append(postArgs);
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map = request.getParameterMap()))) {
            if (argsBuilder.length() != 0) {
                argsBuilder.append('\n');
            }
            argsBuilder.append("queryArgs: ").append(RequestUtil.convertQueryArgsMap(map));
        }
        return argsBuilder.length() == 0 ? null : argsBuilder.toString();
    }

    public static Map<String, String> convertQueryArgsMap(Map<String, String[]> map) {
        HashMap<String, String> queryArgsMap = new HashMap<String, String>(map.size());
        map.forEach((k, v) -> {
            if (((String[])v).length == 1) {
                queryArgsMap.put((String)k, v[0]);
            } else {
                queryArgsMap.put((String)k, Arrays.toString(v));
            }
        });
        return queryArgsMap;
    }
}

