/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.cloud.storage;

import com.ovopark.dc.cloud.storage.OssProcess;
import com.ovopark.dc.common.time.StopWatch;
import com.ovopark.dc.entity.FileMetaData;
import com.ovopark.dc.entity.OcrRecognizeResult;
import com.ovopark.dc.entity.OssUploadResult;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OssAbstractClient
implements OssProcess {
    private static final Logger log = LoggerFactory.getLogger(OssAbstractClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult upload(String moduleName, File file, String filePath, String fileName, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u666e\u901a\u4e0a\u4f20";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doUpload(moduleName, file, filePath, fileName);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("upload {} putObject,requestId: {}, eTag:{}", new Object[]{this.storageType(), ossUploadResult.getRequestId(), ossUploadResult.getETag()});
            }
            log.info("upload {} putObject,time: {} ms, fileName: {}, size:{}, storagePath: {}, moduleName:{}, path: {},", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), fileName, file.length(), file.getPath(), moduleName, filePath});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("upload {} putObject,requestId: {}, eTag:{}", new Object[]{this.storageType(), ossUploadResult.getRequestId(), ossUploadResult.getETag()});
        }
        log.info("upload {} putObject,time: {} ms, fileName: {}, size:{}, storagePath: {}, moduleName:{}, path: {},", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), fileName, file.length(), file.getPath(), moduleName, filePath});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult downLoadFile(String bucketName, String imagePath, String storagePath, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u666e\u901a\u4e0b\u8f7d";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = new OssUploadResult();
        try {
            ossUploadResult = this.doDownLoadFile(bucketName, imagePath, storagePath);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("downLoadFile {} getObject,requestId: {}, eTag:{}", new Object[]{this.storageType(), ossUploadResult.getRequestId(), ossUploadResult.getETag()});
            }
            log.info("downLoadFile {} getObject,time: {} ms, moduleName:{}, path: {}, storagePath:{}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, imagePath, storagePath});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("downLoadFile {} getObject,requestId: {}, eTag:{}", new Object[]{this.storageType(), ossUploadResult.getRequestId(), ossUploadResult.getETag()});
        }
        log.info("downLoadFile {} getObject,time: {} ms, moduleName:{}, path: {}, storagePath:{}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, imagePath, storagePath});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult objectExit(String bucketName, String path, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u6821\u9a8c";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doObjectExit(bucketName, path);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("objectExit {} doesObjectExist,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
            }
            log.info("objectExit {} doesObjectExist,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("objectExit {} doesObjectExist,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("objectExit {} doesObjectExist,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult deleteFile(String bucketName, String path, StopWatch stopWatch) {
        OssUploadResult ossUploadResult;
        String name;
        block5: {
            name = "\u6587\u4ef6\u5220\u9664";
            stopWatch.start(name);
            ossUploadResult = null;
            try {
                OssUploadResult exists = this.objectExit(bucketName, path, stopWatch);
                if (exists != null && exists.isOperate()) {
                    ossUploadResult = this.doDeleteFile(bucketName, path);
                    break block5;
                }
                ossUploadResult = new OssUploadResult(false, bucketName, path);
                ossUploadResult.setErrorResponseAsString("\u6587\u4ef6\u4e0d\u5b58\u5728");
                log.info("deleteFile {} deleteObject, file not exists, moduleName:{}, path: {}", new Object[]{this.storageType(), bucketName, path});
            }
            catch (Throwable throwable) {
                stopWatch.end(name);
                if (ossUploadResult != null) {
                    log.info("deleteFile {} deleteObject,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
                }
                log.info("deleteFile {} deleteObject,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
                throw throwable;
            }
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("deleteFile {} deleteObject,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("deleteFile {} deleteObject,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult unfreeze(String bucketName, String path, int day, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u89e3\u51bb";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doUnfreeze(bucketName, path, day);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("unfreeze {} restoreObject,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
            }
            log.info("unfreeze {} restoreObject,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("unfreeze {} restoreObject,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("unfreeze {} restoreObject,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult freezeState(String bucketName, String path, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u89e3\u51bb";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doFreezeState(bucketName, path);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("freezeState {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
            }
            log.info("freezeState {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("freezeState {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("freezeState {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult copyObject(String fromBucket, String fromPath, String toBucket, String toPath, FileMetaData metaData, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u590d\u5236";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doCopyObject(fromBucket, fromPath, toBucket, toPath, metaData);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("copyObject {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
            }
            log.info("copyObject {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), fromBucket, fromPath});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("copyObject {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("copyObject {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), fromBucket, fromPath});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult listObject(String bucket, String path, String pageSign, Integer size, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u5217\u4e3e";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doListObject(bucket, path, pageSign, size);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("listObject {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
            }
            log.info("listObject {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucket, path});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("listObject {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("listObject {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucket, path});
        return ossUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OssUploadResult getFileMeta(String bucketName, String path, StopWatch stopWatch) {
        String name = "\u6587\u4ef6\u5143\u6570\u636e";
        stopWatch.start(name);
        OssUploadResult ossUploadResult = null;
        try {
            ossUploadResult = this.doGetFileMeta(bucketName, path);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ossUploadResult != null) {
                log.info("getFileMeta {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
            }
            log.info("getFileMeta {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
            throw throwable;
        }
        stopWatch.end(name);
        if (ossUploadResult != null) {
            log.info("getFileMeta {} ongoing-request,operate: {}", (Object)this.storageType(), (Object)ossUploadResult.isOperate());
        }
        log.info("getFileMeta {} ongoing-request,time: {} ms, moduleName:{}, path: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), bucketName, path});
        return ossUploadResult;
    }

    @Override
    public String getUrl(String bucketName, String path) {
        return this.doGetUrl(bucketName, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OcrRecognizeResult recognizeCredential(String fileUrl, Integer type, StopWatch stopWatch) {
        String name = "OCR";
        stopWatch.start(name);
        OcrRecognizeResult ocrRecognizeResult = null;
        try {
            ocrRecognizeResult = this.doRecognizeCredential(fileUrl, type);
        }
        catch (Throwable throwable) {
            stopWatch.end(name);
            if (ocrRecognizeResult != null) {
                log.info("recognizeCredential {} getObject,requestId: {}", (Object)this.storageType(), (Object)ocrRecognizeResult.getRequestId());
            }
            log.info("recognizeCredential {} ongoing-request,time: {} ms, fileUrl:{}, type: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), fileUrl, type});
            throw throwable;
        }
        stopWatch.end(name);
        if (ocrRecognizeResult != null) {
            log.info("recognizeCredential {} getObject,requestId: {}", (Object)this.storageType(), (Object)ocrRecognizeResult.getRequestId());
        }
        log.info("recognizeCredential {} ongoing-request,time: {} ms, fileUrl:{}, type: {}", new Object[]{this.storageType(), stopWatch.getTotalTimeMilliTask(name), fileUrl, type});
        return ocrRecognizeResult;
    }

    protected abstract OssUploadResult doListObject(String var1, String var2, String var3, Integer var4);

    protected abstract OssUploadResult doUpload(String var1, File var2, String var3, String var4);

    protected abstract OssUploadResult doDownLoadFile(String var1, String var2, String var3);

    protected abstract OssUploadResult doObjectExit(String var1, String var2);

    protected abstract OssUploadResult doDeleteFile(String var1, String var2);

    protected abstract String doGetUrl(String var1, String var2);

    protected abstract OssUploadResult doUnfreeze(String var1, String var2, int var3);

    protected abstract String storageType();

    protected abstract OssUploadResult doFreezeState(String var1, String var2);

    protected abstract OssUploadResult doCopyObject(String var1, String var2, String var3, String var4, FileMetaData var5);

    protected abstract OssUploadResult doGetFileMeta(String var1, String var2);

    protected abstract OcrRecognizeResult doRecognizeCredential(String var1, Integer var2);
}

