/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.cloud.storage.client;

import com.aliyun.ocr_api20210707.Client;
import com.aliyun.ocr_api20210707.models.RecognizeBankCardRequest;
import com.aliyun.ocr_api20210707.models.RecognizeBankCardResponse;
import com.aliyun.ocr_api20210707.models.RecognizeBankCardResponseBody;
import com.aliyun.ocr_api20210707.models.RecognizeBusinessLicenseRequest;
import com.aliyun.ocr_api20210707.models.RecognizeBusinessLicenseResponse;
import com.aliyun.ocr_api20210707.models.RecognizeBusinessLicenseResponseBody;
import com.aliyun.ocr_api20210707.models.RecognizeExitEntryPermitToHKRequest;
import com.aliyun.ocr_api20210707.models.RecognizeExitEntryPermitToHKResponse;
import com.aliyun.ocr_api20210707.models.RecognizeExitEntryPermitToHKResponseBody;
import com.aliyun.ocr_api20210707.models.RecognizeIdcardRequest;
import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponse;
import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponseBody;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.RestoreConfiguration;
import com.aliyun.oss.model.RestoreJobParameters;
import com.aliyun.oss.model.RestoreObjectResult;
import com.aliyun.oss.model.RestoreTier;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import com.aliyun.oss.model.StorageClass;
import com.aliyun.teaopenapi.models.Config;
import com.ovopark.dc.cloud.annotation.StorageTypeAnnotation;
import com.ovopark.dc.cloud.storage.OssAbstractClient;
import com.ovopark.dc.cloud.storage.common.AliyunUtils;
import com.ovopark.dc.common.utils.StringUtils;
import com.ovopark.dc.dto.FileMetaDTO;
import com.ovopark.dc.entity.FileBasicInfo;
import com.ovopark.dc.entity.FileMetaData;
import com.ovopark.dc.entity.OcrRecognizeResult;
import com.ovopark.dc.entity.OssUploadResult;
import com.ovopark.dc.enums.ArchiveTypeEnum;
import com.ovopark.dc.enums.StorageTypeEnum;
import com.ovopark.dc.enums.UnfreezeStateEnum;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StorageTypeAnnotation(type="aliyun")
public class AliyunOssClient
extends OssAbstractClient {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssClient.class);
    private OSS client;
    private String accessUrl;
    private String type;
    public boolean active = false;
    private String name;
    private Client ocrClient;
    Map<Integer, StorageClass> archiveTypeMap = new HashMap<Integer, StorageClass>();

    @Override
    public void initClient(String endpoint, String accessKeyId, String accessKeySecret, String accessUrl, String type, String ocrAccessKeyId, String ocrAccessKeySecret, String ocrEndpoint) {
        this.active = true;
        this.client = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        this.type = type;
        this.accessUrl = accessUrl;
        this.name = StorageTypeEnum.aliyun.getKey();
        this.archiveTypeMap.put(ArchiveTypeEnum.STANDARD.getType(), StorageClass.Standard);
        this.archiveTypeMap.put(ArchiveTypeEnum.ARCHIVE.getType(), StorageClass.Archive);
        this.archiveTypeMap.put(ArchiveTypeEnum.COLD_ARCHIVE.getType(), StorageClass.ColdArchive);
        this.archiveTypeMap.put(ArchiveTypeEnum.DEEP_COLD_ARCHIVE.getType(), StorageClass.DeepColdArchive);
        try {
            Config config = new Config().setAccessKeyId(ocrAccessKeyId).setAccessKeySecret(ocrAccessKeySecret).setEndpoint(ocrEndpoint);
            this.ocrClient = new Client(config);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316ocrClient\u51fa\u9519");
        }
        log.info("aliyun\u7684client\u5df2\u7ecf\u542f\u52a8\u5b8c\u6210");
    }

    @Override
    protected OssUploadResult doListObject(String bucket, String path, String pageSign, Integer size) {
        OssUploadResult ossUploadResult = null;
        try {
            ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request(bucket);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setPrefix(path);
            listObjectsRequest.setMaxKeys(size);
            listObjectsRequest.setContinuationToken(pageSign);
            ListObjectsV2Result listing = this.client.listObjectsV2(listObjectsRequest);
            ArrayList<FileBasicInfo> fileBasicInfoList = new ArrayList<FileBasicInfo>();
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                FileBasicInfo fileBasicInfo = new FileBasicInfo();
                String key = objectSummary.getKey();
                int index = key.lastIndexOf("/");
                if (index != -1) {
                    fileBasicInfo.setFileName(key.substring(index + 1));
                } else {
                    fileBasicInfo.setFileName(key);
                }
                fileBasicInfo.setUrl(this.doGetUrl(bucket, key));
                fileBasicInfo.setPath(key);
                fileBasicInfo.setSize(objectSummary.getSize());
                fileBasicInfoList.add(fileBasicInfo);
            }
            ossUploadResult = new OssUploadResult(listing.getCommonPrefixes(), fileBasicInfoList, listing.getRequestId(), bucket, path, listing.getNextContinuationToken());
            listing.getCommonPrefixes();
        }
        catch (OSSException e) {
            log.error("doListObject Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (Exception e) {
            log.error("doListObject Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult(e);
        }
        return ossUploadResult;
    }

    @Override
    protected OssUploadResult doUpload(String moduleName, File file, String filePath, String fileName) {
        OssUploadResult ossUploadResult = null;
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setCacheControl("no-cache");
            metadata.setHeader("x-oss-forbid-overwrite", (Object)"false");
            metadata.setContentType(Mimetypes.getInstance().getMimetype(fileName));
            PutObjectResult putObject = this.client.putObject(moduleName, filePath, file, metadata);
            String url = this.doGetUrl(moduleName, filePath);
            ossUploadResult = new OssUploadResult(url, putObject.getRequestId(), putObject.getETag(), moduleName, filePath);
        }
        catch (OSSException e) {
            log.error("doUpload Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (Exception e) {
            log.error("doUpload Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult(e);
        }
        return ossUploadResult;
    }

    @Override
    protected OssUploadResult doDownLoadFile(String moduleName, String imagePath, String storagePath) {
        OssUploadResult ossUploadResult = null;
        try {
            File file = new File(storagePath);
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            ObjectMetadata metadata = this.client.getObject(new GetObjectRequest(moduleName, imagePath), file);
            ossUploadResult = new OssUploadResult(file, metadata.getRequestId(), metadata.getETag(), moduleName, imagePath);
        }
        catch (OSSException e) {
            log.error("doDownLoadFile Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (ClientException | IOException e) {
            log.error("doDownLoadFile Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult((Exception)e);
        }
        catch (Exception e) {
            log.error("doDownLoadFile Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult(e);
        }
        return ossUploadResult;
    }

    @Override
    protected OssUploadResult doObjectExit(String bucketName, String path) {
        OssUploadResult ossUploadResult = null;
        try {
            boolean exists = this.client.doesObjectExist(bucketName, path);
            ossUploadResult = new OssUploadResult(exists, bucketName, path);
        }
        catch (OSSException e) {
            log.error("doObjectExit Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (ClientException e) {
            log.error("doObjectExit Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult((Exception)((Object)e));
        }
        return ossUploadResult;
    }

    @Override
    protected OssUploadResult doDeleteFile(String bucketName, String path) {
        OssUploadResult ossUploadResult = null;
        try {
            this.client.deleteObject(bucketName, path);
            ossUploadResult = new OssUploadResult(true, bucketName, path);
        }
        catch (OSSException e) {
            log.error("doDeleteFile Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (ClientException e) {
            log.error("doDeleteFile Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult((Exception)((Object)e));
        }
        return ossUploadResult;
    }

    @Override
    protected String doGetUrl(String bucketName, String path) {
        return this.type + "//" + bucketName + "." + this.accessUrl + "/" + path;
    }

    @Override
    protected String storageType() {
        return this.name;
    }

    @Override
    protected OssUploadResult doFreezeState(String bucketName, String path) {
        OssUploadResult ossUploadResult = null;
        try {
            UnfreezeStateEnum stateEnum = UnfreezeStateEnum.UNFREEZE;
            boolean finish = false;
            String[] objects = path.split("/");
            if (objects[objects.length - 1].contains(".")) {
                ObjectMetadata metadata = this.client.headObject(bucketName, path);
                String restoreString = metadata.getObjectRawRestore();
                if (StringUtils.isEmpty((Object)restoreString)) {
                    stateEnum = UnfreezeStateEnum.NO_UNFREEZE;
                }
                if (StringUtils.isNotEmpty((Object)restoreString) && restoreString.contains("ongoing-request=\"false\"")) {
                    finish = true;
                    stateEnum = UnfreezeStateEnum.FINISH_UNFREEZE;
                }
                ossUploadResult = new OssUploadResult(finish, bucketName, path);
            } else {
                ListObjectsV2Result objectsV2Result = this.client.listObjectsV2(bucketName, path);
                List data = objectsV2Result.getObjectSummaries();
                if (data.isEmpty()) {
                    stateEnum = UnfreezeStateEnum.NO_UNFREEZE_DATA;
                } else {
                    long completeNum = 0L;
                    long unCompleteNum = 0L;
                    for (OSSObjectSummary objectSummary : data) {
                        String restoreString = objectSummary.getRestoreInfo();
                        if (StringUtils.isNotEmpty((Object)restoreString) && restoreString.contains("ongoing-request=\"false\"")) {
                            ++completeNum;
                        }
                        if (!StringUtils.isNotEmpty((Object)restoreString) || !restoreString.contains("ongoing-request=\"true\"")) continue;
                        ++unCompleteNum;
                    }
                    if (completeNum == 0L && unCompleteNum == 0L) {
                        stateEnum = UnfreezeStateEnum.NO_UNFREEZE;
                    } else if (completeNum > 0L && unCompleteNum == 0L) {
                        finish = true;
                        stateEnum = UnfreezeStateEnum.FINISH_UNFREEZE;
                    }
                    log.info("{}-{},\u89e3\u51bb\u64cd\u4f5c\u5df2\u7ecf\u5b8c\u6210{}, \u8fd8\u5269\u4e0b{}", new Object[]{bucketName, path, completeNum, unCompleteNum});
                    ossUploadResult = new OssUploadResult(finish, bucketName, path, completeNum, unCompleteNum);
                }
            }
            ossUploadResult.setErrorResponseAsString(stateEnum.getName());
            ossUploadResult.setStatusCode(stateEnum.getState());
        }
        catch (OSSException e) {
            log.error("doFreezeState Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (ClientException | NullPointerException e) {
            log.error("doFreezeState Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult((Exception)e);
        }
        return ossUploadResult;
    }

    @Override
    protected OssUploadResult doCopyObject(String fromBucket, String fromPath, String toBucket, String toPath, FileMetaData metaData) {
        OssUploadResult ossUploadResult = null;
        try {
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(fromBucket, fromPath, toBucket, toPath);
            if (metaData != null) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                if (metaData.isNoCache()) {
                    objectMetadata.setCacheControl("no-cache");
                }
                if (metaData.getArchiveType() != null && this.archiveTypeMap.containsKey(metaData.getArchiveType().getType())) {
                    objectMetadata.setHeader("x-oss-storage-class", (Object)this.archiveTypeMap.get(metaData.getArchiveType().getType()));
                }
                copyObjectRequest.setNewObjectMetadata(objectMetadata);
            }
            CopyObjectResult result = this.client.copyObject(copyObjectRequest);
            ossUploadResult = new OssUploadResult(true, result.getRequestId(), toBucket, toPath);
        }
        catch (OSSException e) {
            log.error("doCopyObject Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (ClientException e) {
            log.error("doCopyObject Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult((Exception)((Object)e));
        }
        return ossUploadResult;
    }

    @Override
    protected OssUploadResult doGetFileMeta(String bucketName, String path) {
        OssUploadResult ossUploadResult = null;
        try {
            SimplifiedObjectMeta objectMeta = this.client.getSimplifiedObjectMeta(bucketName, path);
            FileMetaDTO fileMetaDTO = new FileMetaDTO(path, this.storageType(), bucketName);
            fileMetaDTO.setFileSize(objectMeta.getSize());
            fileMetaDTO.setLastModified(objectMeta.getLastModified());
            fileMetaDTO.setAccessTime((String)objectMeta.getHeaders().get("x-oss-last-access-time"));
            ossUploadResult = new OssUploadResult(fileMetaDTO, objectMeta.getRequestId(), objectMeta.getETag(), bucketName, path);
        }
        catch (OSSException e) {
            log.error("getFileMeta Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (Exception e) {
            log.error("getFileMeta Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult(e);
        }
        return ossUploadResult;
    }

    @Override
    protected OcrRecognizeResult doRecognizeCredential(String fileUrl, Integer type) {
        OcrRecognizeResult ocrRecognizeResult = null;
        try {
            switch (type) {
                case 1: {
                    RecognizeIdcardRequest idCardRequest = new RecognizeIdcardRequest();
                    idCardRequest.setUrl(fileUrl);
                    RecognizeIdcardResponse idCardResponse = this.ocrClient.recognizeIdcard(idCardRequest);
                    RecognizeIdcardResponseBody idCardBody = idCardResponse.getBody();
                    ocrRecognizeResult = new OcrRecognizeResult(idCardBody.getRequestId(), AliyunUtils.translateIdCard(idCardBody.getData()));
                    break;
                }
                case 2: {
                    RecognizeExitEntryPermitToHKRequest hkRequest = new RecognizeExitEntryPermitToHKRequest();
                    hkRequest.setUrl(fileUrl);
                    RecognizeExitEntryPermitToHKResponse hkResponse = this.ocrClient.recognizeExitEntryPermitToHK(hkRequest);
                    RecognizeExitEntryPermitToHKResponseBody hkBody = hkResponse.getBody();
                    ocrRecognizeResult = new OcrRecognizeResult(hkBody.getRequestId(), AliyunUtils.translateHk(hkBody.getData()));
                    break;
                }
                case 3: {
                    RecognizeBankCardRequest bankCardRequest = new RecognizeBankCardRequest();
                    bankCardRequest.setUrl(fileUrl);
                    RecognizeBankCardResponse bankCardResponse = this.ocrClient.recognizeBankCard(bankCardRequest);
                    RecognizeBankCardResponseBody bankCardBody = bankCardResponse.getBody();
                    ocrRecognizeResult = new OcrRecognizeResult(bankCardBody.getRequestId(), AliyunUtils.translateBankCard(bankCardBody.getData()));
                    break;
                }
                case 4: {
                    RecognizeBusinessLicenseRequest businessLicenseRequest = new RecognizeBusinessLicenseRequest();
                    businessLicenseRequest.setUrl(fileUrl);
                    RecognizeBusinessLicenseResponse businessLicenseResponse = this.ocrClient.recognizeBusinessLicense(businessLicenseRequest);
                    RecognizeBusinessLicenseResponseBody body = businessLicenseResponse.getBody();
                    ocrRecognizeResult = new OcrRecognizeResult(body.getRequestId(), AliyunUtils.translateBusinessLicense(body.getData()));
                }
            }
        }
        catch (Exception e) {
            log.error("doRecognizeCredential Caught an Exception,, error message:{}", (Object)e.toString());
            ocrRecognizeResult = new OcrRecognizeResult((Throwable)e);
        }
        return ocrRecognizeResult;
    }

    @Override
    protected OssUploadResult doUnfreeze(String bucketName, String path, int day) {
        OssUploadResult ossUploadResult = null;
        try {
            ObjectMetadata objectMetadata = this.client.getObjectMetadata(bucketName, path);
            StorageClass storageClass = objectMetadata.getObjectStorageClass();
            if (storageClass == StorageClass.Archive || storageClass == StorageClass.ColdArchive || storageClass == StorageClass.DeepColdArchive) {
                RestoreJobParameters jobParameters = new RestoreJobParameters(RestoreTier.RESTORE_TIER_BULK);
                RestoreConfiguration configuration = new RestoreConfiguration(Integer.valueOf(day), jobParameters);
                RestoreObjectResult restoreObjectResult = this.client.restoreObject(bucketName, path, configuration);
                ossUploadResult = new OssUploadResult(true, restoreObjectResult.getRequestId(), bucketName, path);
            } else {
                ossUploadResult = new OssUploadResult(false, bucketName, path);
                ossUploadResult.setErrorResponseAsString("\u4e0d\u662f\u5f52\u6863\u6587\u4ef6\uff0c\u4e0d\u9700\u8981\u89e3\u51bb\u64cd\u4f5c");
            }
        }
        catch (OSSException e) {
            log.error("doUnfreeze Caught an OSSException,, error message:{}, error code: {}, requestId:{}, hostId:{}", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getRequestId(), e.getHostId()});
            ossUploadResult = new OssUploadResult((Exception)((Object)e), e.getRequestId(), e.getErrorMessage(), 520);
        }
        catch (ClientException e) {
            log.error("doUnfreeze Caught an Exception,, error message:{}", (Object)e.toString());
            ossUploadResult = new OssUploadResult((Exception)((Object)e));
        }
        return ossUploadResult;
    }
}

