/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.cache;

import com.ovopark.dc.common.cache.Buffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ArrayBlockingQueueBuffer<T>
implements Buffer<T> {
    private ArrayBlockingQueue<T> queue;
    private int size;

    public ArrayBlockingQueueBuffer(int size) {
        this.queue = new ArrayBlockingQueue(size);
        this.size = size;
    }

    @Override
    public int write(T data) {
        try {
            if (this.queue.offer(data, 100L, TimeUnit.MILLISECONDS)) {
                return 1;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public List<T> read() {
        return new ArrayList<T>(this.queue);
    }

    @Override
    public List<T> drain() {
        ArrayList result = new ArrayList();
        this.queue.drainTo(result);
        return result;
    }

    @Override
    public int getBufferSize() {
        return this.size;
    }
}

