/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.common.cache;

import com.ovopark.dc.common.cache.consumer.IConsumer;
import com.ovopark.dc.common.cache.consumer.IConsumerPool;
import com.ovopark.dc.common.cache.consumer.IDriver;
import com.ovopark.dc.common.cache.produce.Channel;
import com.ovopark.dc.common.cache.produce.SimpleRollPartitioner;

public class BufferProcessor<T> {
    private Channel<T> channel;
    private String name;
    private IDriver driver;

    public BufferProcessor(String name, int bufferSize, int channelSize) {
        this.name = name;
        this.channel = new Channel(this.name, bufferSize, channelSize, new SimpleRollPartitioner());
    }

    public boolean produce(T data) {
        if (this.driver == null || !this.driver.running()) {
            return false;
        }
        return this.channel.save(data);
    }

    public void addConsumer(IConsumerPool consumerPool, IConsumer consumer) {
        this.driver = consumerPool;
        consumerPool.add(this.channel, consumer);
        this.driver.start();
    }
}

